
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>February 15–21, 2026 • Weekly Destiny View</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #0b0d10;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1100px;
      margin: 0 auto;
      padding: 24px 16px 48px;
    }

    a {
      color: var(--accent);
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    header {
      margin-bottom: 18px;
    }

    .back-link {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      display: inline-flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 10px;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 1.7rem;
      letter-spacing: 0.06em;
      text-transform: uppercase;
    }

    .subtitle {
      font-size: 0.95rem;
      color: var(--muted);
      margin-top: 4px;
    }

    .week-meta {
      margin-top: 10px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
    }

    .pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      color: var(--muted);
      background: rgba(0, 0, 0, 0.3);
    }

    .pill strong {
      color: var(--accent);
    }

    .days-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
      margin-top: 20px;
    }

    .day-card {
      background: var(--card-bg);
      border-radius: 16px;
      padding: 10px 12px;
      border: 1px solid var(--border);
      box-shadow: 0 10px 22px rgba(0, 0, 0, 0.45);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .day-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      margin-bottom: 4px;
    }

    .day-name {
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .day-tag {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-top: 4px;
      margin-bottom: 2px;
    }

    .day-card p {
      margin: 3px 0 5px;
    }

    .bullet-list {
      padding-left: 16px;
      margin: 2px 0 4px;
    }

    .bullet-list li {
      margin-bottom: 3px;
    }

    .ritual {
      margin-top: 4px;
      padding: 5px 7px;
      border-radius: 10px;
      border: 1px dashed var(--border);
      background: rgba(0, 0, 0, 0.25);
      font-size: 0.86rem;
    }

    .ritual strong {
      color: var(--accent);
    }

    .do-avoid {
      display: flex;
      gap: 8px;
      margin-top: 4px;
      font-size: 0.8rem;
    }

    .do-avoid div {
      flex: 1;
    }

    .do-avoid b {
      display: block;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      font-size: 0.7rem;
      margin-bottom: 1px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.4rem;
      }
    }
  </style>
</head>
<body>
  <div class="page">
    <header>
      <a href="../index.php" class="back-link">← Back to Home</a>
      <h1>Week 3 • February 15–21, 2026</h1>
      <div class="subtitle">
        Choosing What Stays • Committing to what works and releasing what doesn’t.
      </div>
      <div class="week-meta">
        <div class="pill"><strong>Week Focus:</strong> Selection, commitment, and resource-aware planning.</div>
        <div class="pill"><strong>Best Use:</strong> Narrowing focus, locking in priorities, and gently adjusting goals.</div>
      </div>
    </header>

    <section class="days-grid">
      
      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sun • February 15</div>
          <div class="day-tag">Decision Breeze</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally lighter; you sense which experiments want to stay and which want to gracefully end.</p>
        <div class="label">Spiritual</div>
        <p>Spirit encourages decisions based on how things feel over time, not one high or low moment.</p>
        <div class="label">Financial</div>
        <p>Good day to decide which experiments you’ll continue into March.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Mark each experiment as “keep,” “tweak,” or “release” based on both results and how they feel.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Choose at least one thing to stop doing.</li><li>Let yourself keep what works even if it wasn’t in your original plan.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Dragging along experiments that clearly drain you.</li><li>Clinging to ideas purely because of sunk cost.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • February 16</div>
          <div class="day-tag">Focused Commitment</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions settle around a smaller set of clear priorities.</p>
        <div class="label">Spiritual</div>
        <p>Your soul is asking you to devote yourself more fully to fewer, better things.</p>
        <div class="label">Financial</div>
        <p>Ideal for committing to the top one or two experiments that show promise.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write a simple 2–3 week commitment statement for each experiment you’re keeping.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Narrow your focus to what truly matters.</li><li>Allocate time and energy intentionally.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Trying to keep everything in play “just in case.”</li><li>Spreading yourself thin across eight directions.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • February 17</div>
          <div class="day-tag">Resource Review</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally pragmatic; you feel more willing to look at what resources you have and what you need.</p>
        <div class="label">Spiritual</div>
        <p>Spirit supports realistic resource assessment: time, energy, money, and support.</p>
        <div class="label">Financial</div>
        <p>Good day for adjusting scopes and expectations to fit available resources.</p>
        <div class="ritual">
          <strong>Ritual:</strong> List your current resources and ask: “Given these, what’s the wisest way to proceed?”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Scale plans to your true capacity.</li><li>Seek support where it will make the biggest difference.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Ignoring resource constraints and hoping for the best.</li><li>Doing everything solo when help is available.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • February 18</div>
          <div class="day-tag">Mid-Month Checkpoint</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions may spike briefly if you realize some goals need adjusting.</p>
        <div class="label">Spiritual</div>
        <p>Spirit reassures you that adaptation is strength, not failure.</p>
        <div class="label">Financial</div>
        <p>Good for mid-month course corrections in both money and work goals.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Update any targets or timelines that no longer feel realistic or aligned.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Be honest about what’s actually possible this month.</li><li>Pivot gently instead of forcing old plans.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Shaming yourself for adjusting goals.</li><li>Stubbornly clinging to a plan that clearly isn’t working.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • February 19</div>
          <div class="day-tag">Inner Alignment</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally introspective; you sense where you’re still doing things for old reasons.</p>
        <div class="label">Spiritual</div>
        <p>Your higher self asks: “Is this aligned with who I am now, or who I used to be?”</p>
        <div class="label">Financial</div>
        <p>Light money/work; focus more on checking the “why” behind your actions.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Journal on: “What am I still doing out of habit or fear rather than genuine desire?”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let go of at least one obligation that no longer fits.</li><li>Realign your actions with your current identity.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Keeping everything the same because changing feels awkward.</li><li>Pretending you haven’t outgrown something.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Fri • February 20</div>
          <div class="day-tag">Sharing from Center</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally centered; you’re able to share from a grounded place.</p>
        <div class="label">Spiritual</div>
        <p>Spirit amplifies messages that arise from your true center, not from anxiety.</p>
        <div class="label">Financial</div>
        <p>Great for communicating your new direction to others (clients, collaborators, audience).</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write and share a short message about where you’re headed and what you’re focusing on now.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Speak clearly about your path and priorities.</li><li>Allow the right people to self-select in response.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Over-explaining every detail to everyone.</li><li>Apologizing for evolving.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sat • February 21</div>
          <div class="day-tag">Integration & Rest</div>
        </div>
        <div class="label">Emotional</div>
        <p>Your emotions want a softer landing after important choices this week.</p>
        <div class="label">Spiritual</div>
        <p>Spirit anchors recent decisions into your nervous system—rest helps them stick.</p>
        <div class="label">Financial</div>
        <p>Minimal money/work; simply hold your new priorities with calm confidence.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Do something soothing while mentally affirming: “These are my choices, and I stand by them.”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let your body acclimate to your new direction.</li><li>Trust that integration happens even when you’re not “doing.”</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Second-guessing every choice immediately.</li><li>Seeking constant reassurance from others.</li>
            </ul>
          </div>
        </div>
      </article>
    
    </section>
  </div>
</body>
</html>
