<?php
// Destiny Almanac 2026 – Q1 (PHP version)
?><!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Destiny Almanac • 2026 Q1 Master Timeline</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #05060a;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    * {
      box-sizing: border-box;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1180px;
      margin: 0 auto;
      padding: 24px 16px 56px;
    }

    header {
      margin-bottom: 22px;
      text-align: left;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 2.1rem;
      letter-spacing: 0.1em;
      text-transform: uppercase;
    }

    .subtitle {
      margin-top: 8px;
      color: var(--muted);
      font-size: 0.95rem;
    }

    .years-row {
      margin-top: 12px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
    }

    .year-pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
    }

    .hint {
      margin-top: 8px;
      font-size: 0.78rem;
      color: var(--muted);
    }

    .months-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 16px;
      margin-top: 26px;
    }

    .month-card {
      background: var(--card-bg);
      border-radius: 18px;
      padding: 14px 16px 16px;
      border: 1px solid var(--border);
      box-shadow: var(--shadow);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .month-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      gap: 8px;
      margin-bottom: 4px;
    }

    .month-name {
      font-family: var(--font-display);
      font-size: 1.1rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .month-year {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .month-theme {
      font-size: 0.86rem;
      margin-bottom: 6px;
    }

    .tag-row {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      margin-bottom: 8px;
    }

    .tag {
      font-size: 0.7rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      border-radius: 999px;
      padding: 2px 8px;
      border: 1px solid var(--border);
      color: var(--muted);
    }

    .week-select-label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-bottom: 3px;
    }

    select {
      width: 100%;
      padding: 6px 8px;
      border-radius: 999px;
      border: 1px solid var(--border);
      background: #05060a;
      color: var(--text);
      font-size: 0.82rem;
      font-family: var(--font-main);
    }

    option {
      color: #000;
    }

    .note-small {
      font-size: 0.75rem;
      color: var(--muted);
      margin-top: 6px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.6rem;
      }
    }
  </style>
  <script>
    function goToWeek(sel) {
      if (sel && sel.value) {
        window.location.href = sel.value;
      }
    }
  </script>
</head>
<body>
  <div class="page">
    <header>
      <h1>Destiny Almanac</h1>
      <div class="subtitle">
        2026 Q1 Multi-Year Destiny Forecast • Weekly & Daily Guidance<br />
        Numerology-based arc: stepping fully into <strong>Personal Year 5 (Expansion)</strong>.
      </div>
      <div class="years-row">
        <div class="year-pill"><strong>2026</strong> • Expansion & Power</div>
      </div>
      <div class="hint">
        Each month below has a dropdown. Choose a week to open its detailed
        emotional, spiritual, financial and ritual guidance. This bundle activates
        <strong>January, February and March 2026</strong>.
      </div>
    </header>

    <section class="months-grid">
      <!-- January 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">January</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> Opening the Door — gentle acceleration, clearing leftovers from 2025, setting new baselines.
        </p>
        <div class="tag-row">
          <span class="tag">Reset</span>
          <span class="tag">Foundations</span>
          <span class="tag">Energy Calibration</span>
        </div>
        <div class="week-select-label">Open a January week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-01-week1.php">Week 1 • Jan 1–7 — Opening the Door</option>
          <option value="weeks/2026-01-week2.php">Week 2 • Jan 8–14 — Establishing Rhythm</option>
          <option value="weeks/2026-01-week3.php">Week 3 • Jan 15–21 — Clearing & Choosing</option>
          <option value="weeks/2026-01-week4.php">Week 4 • Jan 22–31 — Laying Foundations</option>
        </select>
        <div class="note-small">Use January as your baseline reset month for the whole Year 5 arc.</div>
      </article>

      <!-- February 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">February</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> Testing New Momentum — trial runs, experiments, small risks that preview March’s surge.
        </p>
        <div class="tag-row">
          <span class="tag">Experiment</span>
          <span class="tag">Signals</span>
          <span class="tag">Preparation</span>
        </div>
        <div class="week-select-label">Open a February week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-02-week1.php">Week 1 • Feb 1–7 — Experiments & Signals</option>
          <option value="weeks/2026-02-week2.php">Week 2 • Feb 8–14 — Refining Experiments</option>
          <option value="weeks/2026-02-week3.php">Week 3 • Feb 15–21 — Choosing What Stays</option>
          <option value="weeks/2026-02-week4.php">Week 4 • Feb 22–28 — Preparing for March’s Surge</option>
        </select>
      </article>

      <!-- March 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">March</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> Power Surge — decisions, bold moves, visible shifts in money, work and identity.
        </p>
        <div class="tag-row">
          <span class="tag">Power</span>
          <span class="tag">Courage</span>
          <span class="tag">Launch Energy</span>
        </div>
        <div class="week-select-label">Open a March week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-03-week1.php">Week 1 • Mar 1–7 — Warming Up the Engine</option>
          <option value="weeks/2026-03-week2.php">Week 2 • Mar 8–14 — Crossing the Threshold</option>
          <option value="weeks/2026-03-week3.php">Week 3 • Mar 15–21 — Owning Your Power</option>
          <option value="weeks/2026-03-week4.php">Week 4 • Mar 22–31 — Consolidate & Aim Forward</option>
        </select>
        <div class="note-small">
          March is your high-voltage month: use January and February as setup, March as the breakthrough.
        </div>
      </article>
    </section>
  </div>
</body>
</html>
