
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>March 15–21, 2026 • Weekly Destiny View</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #0b0d10;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1100px;
      margin: 0 auto;
      padding: 24px 16px 48px;
    }

    a {
      color: var(--accent);
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    header {
      margin-bottom: 18px;
    }

    .back-link {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      display: inline-flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 10px;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 1.7rem;
      letter-spacing: 0.06em;
      text-transform: uppercase;
    }

    .subtitle {
      font-size: 0.95rem;
      color: var(--muted);
      margin-top: 4px;
    }

    .week-meta {
      margin-top: 10px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
    }

    .pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      color: var(--muted);
      background: rgba(0, 0, 0, 0.3);
    }

    .pill strong {
      color: var(--accent);
    }

    .days-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
      margin-top: 20px;
    }

    .day-card {
      background: var(--card-bg);
      border-radius: 16px;
      padding: 10px 12px;
      border: 1px solid var(--border);
      box-shadow: 0 10px 22px rgba(0, 0, 0, 0.45);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .day-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      margin-bottom: 4px;
    }

    .day-name {
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .day-tag {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-top: 4px;
      margin-bottom: 2px;
    }

    .day-card p {
      margin: 3px 0 5px;
    }

    .bullet-list {
      padding-left: 16px;
      margin: 2px 0 4px;
    }

    .bullet-list li {
      margin-bottom: 3px;
    }

    .ritual {
      margin-top: 4px;
      padding: 5px 7px;
      border-radius: 10px;
      border: 1px dashed var(--border);
      background: rgba(0, 0, 0, 0.25);
      font-size: 0.86rem;
    }

    .ritual strong {
      color: var(--accent);
    }

    .do-avoid {
      display: flex;
      gap: 8px;
      margin-top: 4px;
      font-size: 0.8rem;
    }

    .do-avoid div {
      flex: 1;
    }

    .do-avoid b {
      display: block;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      font-size: 0.7rem;
      margin-bottom: 1px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.4rem;
      }
    }
  </style>
</head>
<body>
  <div class="page">
    <header>
      <a href="../index.php" class="back-link">← Back to Home</a>
      <h1>Week 3 • March 15–21, 2026</h1>
      <div class="subtitle">
        Owning Your Power • Stabilizing new boundaries, identities and levels of responsibility.
      </div>
      <div class="week-meta">
        <div class="pill"><strong>Week Focus:</strong> Integration of bold moves into your everyday identity.</div>
        <div class="pill"><strong>Best Use:</strong> Updating roles, setting boundaries, refining offers and statements of who you are now.</div>
      </div>
    </header>

    <section class="days-grid">
      
      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sun • March 15</div>
          <div class="day-tag">Power Surge Day</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions are charged but purposeful; you sense that today matters for your future trajectory.</p>
        <div class="label">Spiritual</div>
        <p>Spirit pushes you toward the braver choice, not the safer one, especially around visibility and leadership.</p>
        <div class="label">Financial</div>
        <p>Excellent for taking a concrete step on a significant financial or work decision you’ve been circling.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Create a small “decision altar” with a candle and an object of courage; write your key decision on paper and sit with it for 3–5 minutes.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Make one clear, irreversible move that serves your future self.</li><li>Speak one honest sentence you’ve been holding back.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Letting fear decide your timeline.</li><li>Over-explaining yourself to win universal approval.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • March 16</div>
          <div class="day-tag">Identity Upgrade</div>
        </div>
        <div class="label">Emotional</div>
        <p>You may feel a subtle friction between who you’ve been and who you’re becoming; mood swings are possible.</p>
        <div class="label">Spiritual</div>
        <p>Your soul invites you to ask: “What roles no longer fit?” and “What am I ready to be seen as now?”</p>
        <div class="label">Financial</div>
        <p>Good day for revisiting bios, offers, or how you describe your work—updating them to match your new level.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Rewrite a short bio or description of your work that reflects the version of you you’re growing into.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Allow yourself to outgrow old roles.</li><li>Take one step to present yourself at your true level.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Playing small to keep others comfortable.</li><li>Holding onto titles that no longer feel alive.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • March 17</div>
          <div class="day-tag">Boundary Refinement</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you notice where resentment or fatigue spikes—that’s where boundaries want attention.</p>
        <div class="label">Spiritual</div>
        <p>Spirit speaks through irritation today; it highlights where you’ve been over-giving or under-asking.</p>
        <div class="label">Financial</div>
        <p>Ideal for adjusting agreements, schedules, or client boundaries to protect your energy and income.</p>
        <div class="ritual">
          <strong>Ritual:</strong> List three situations where you feel drained. For each, write one boundary you could test in the next week.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Practice saying “no” or “not like that, but like this instead.”</li><li>Block protected focus time in your calendar.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Agreeing automatically to every request.</li><li>Using money worries as an excuse to ignore your limits.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • March 18</div>
          <div class="day-tag">Aligned Action</div>
        </div>
        <div class="label">Emotional</div>
        <p>Your emotional state steadies when your actions line up with your values; you may feel unusually productive.</p>
        <div class="label">Spiritual</div>
        <p>Spirit rewards aligned work with a sense of flow and rightness, even if tasks are challenging.</p>
        <div class="label">Financial</div>
        <p>Strong day for sustained focus on one or two high-impact tasks that can reshape your next quarter.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Before working, say: “For the next 90 minutes, I devote myself to the one action that matters most.” Then set a timer.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Batch similar tasks to ride momentum.</li><li>Protect your best working hours from distraction.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Fragmenting your attention across ten projects.</li><li>Checking messages constantly while doing deep work.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • March 19</div>
          <div class="day-tag">Receiving Feedback</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions may flare if you misunderstand feedback as personal attack; breathe before reacting.</p>
        <div class="label">Spiritual</div>
        <p>Your soul is asking: “What if feedback is raw data, not a verdict on your worth?”</p>
        <div class="label">Financial</div>
        <p>Useful for refining offers, messaging, and pricing based on what’s actually resonating.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Ask one trusted person: “What do you see me doing at my absolute best?” Capture their answer in your journal.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Stay curious in the face of critique.</li><li>Keep what’s useful and lovingly discard the rest.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Internalizing every comment as truth.</li><li>Seeking approval instead of clarity.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Fri • March 20</div>
          <div class="day-tag">Magnetic Confidence</div>
        </div>
        <div class="label">Emotional</div>
        <p>You may feel flashes of genuine confidence, more rooted and less performative than before.</p>
        <div class="label">Spiritual</div>
        <p>Spirit mirrors your self-trust; the more you stand in it, the more aligned opportunities notice you.</p>
        <div class="label">Financial</div>
        <p>Ideal for sharing wins, showcasing your work, or inviting people into your world.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write down three concrete ways your work has helped others. Let that reality anchor your next share or pitch.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Share an authentic win without downplaying it.</li><li>Invite someone specific into your work or offers.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Shrinking when praised.</li><li>Waiting for a perfect moment to express what you do.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sat • March 21</div>
          <div class="day-tag">Integration & Gratitude</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions soften; you begin to feel the impact of the week’s boundary and identity shifts.</p>
        <div class="label">Spiritual</div>
        <p>Spirit asks you to seal changes with gratitude so they root more deeply into your field.</p>
        <div class="label">Financial</div>
        <p>Gentle day for tracking progress and noticing how your money/work energy feels different from early March.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Take 10 minutes to list everything that has improved—even slightly—since the start of the month.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Acknowledge your own growth in detail.</li><li>Let yourself enjoy the sense of forward motion.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Rushing into another big project immediately.</li><li>Focusing only on what hasn’t happened yet.</li>
            </ul>
          </div>
        </div>
      </article>
    
    </section>
  </div>
</body>
</html>
