
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>June 22–30, 2026 • Weekly Destiny View</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #0b0d10;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1100px;
      margin: 0 auto;
      padding: 24px 16px 48px;
    }

    a {
      color: var(--accent);
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    header {
      margin-bottom: 18px;
    }

    .back-link {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      display: inline-flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 10px;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 1.7rem;
      letter-spacing: 0.06em;
      text-transform: uppercase;
    }

    .subtitle {
      font-size: 0.95rem;
      color: var(--muted);
      margin-top: 4px;
    }

    .week-meta {
      margin-top: 10px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
    }

    .pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      color: var(--muted);
      background: rgba(0, 0, 0, 0.3);
    }

    .pill strong {
      color: var(--accent);
    }

    .days-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
      margin-top: 20px;
    }

    .day-card {
      background: var(--card-bg);
      border-radius: 16px;
      padding: 10px 12px;
      border: 1px solid var(--border);
      box-shadow: 0 10px 22px rgba(0, 0, 0, 0.45);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .day-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      margin-bottom: 4px;
    }

    .day-name {
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .day-tag {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-top: 4px;
      margin-bottom: 2px;
    }

    .day-card p {
      margin: 3px 0 5px;
    }

    .bullet-list {
      padding-left: 16px;
      margin: 2px 0 4px;
    }

    .bullet-list li {
      margin-bottom: 3px;
    }

    .ritual {
      margin-top: 4px;
      padding: 5px 7px;
      border-radius: 10px;
      border: 1px dashed var(--border);
      background: rgba(0, 0, 0, 0.25);
      font-size: 0.86rem;
    }

    .ritual strong {
      color: var(--accent);
    }

    .do-avoid {
      display: flex;
      gap: 8px;
      margin-top: 4px;
      font-size: 0.8rem;
    }

    .do-avoid div {
      flex: 1;
    }

    .do-avoid b {
      display: block;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      font-size: 0.7rem;
      margin-bottom: 1px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.4rem;
      }
    }
  </style>
</head>
<body>
  <div class="page">
    <header>
      <a href="../index.php" class="back-link">← Back to Home</a>
      <h1>Week 4 • June 22–30, 2026</h1>
      <div class="subtitle">
        Aiming H2 • Choosing how you’ll walk into the second half of your Year 5.
      </div>
      <div class="week-meta">
        <div class="pill"><strong>Week Focus:</strong> Strategic planning, prioritization, and ritual closure.</div>
        <div class="pill"><strong>Best Use:</strong> Setting H2 priorities, money strategy, and mid-year rituals.</div>
      </div>
    </header>

    <section class="days-grid">
      
      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • June 22</div>
          <div class="day-tag">Strategic Horizon</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you can look ahead without as much fear or fog.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to aim H2 with both courage and realism.</p>
        <div class="label">Financial</div>
        <p>Good for sketching big-picture goals for July–December.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write 3–5 big arcs you’d like to see unfold in the second half of the year.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let yourself imagine without micromanaging every step.</li><li>Balance ambition with compassion for your humanity.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Setting goals so big they paralyze you.</li><li>Refusing to name any goals to avoid disappointment.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • June 23</div>
          <div class="day-tag">Priority Sorting</div>
        </div>
        <div class="label">Emotional</div>
        <p>You feel a strong urge to sort what actually matters from what does not.</p>
        <div class="label">Spiritual</div>
        <p>Spirit encourages sharper priority lines for H2 to protect your time and heart.</p>
        <div class="label">Financial</div>
        <p>Ideal for deciding which projects or paths will get your prime energy.</p>
        <div class="ritual">
          <strong>Ritual:</strong> List all current projects and mark each as “Core,” “Supportive,” or “Retire.”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Commit to a short list of core priorities.</li><li>Release or downgrade at least one project.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Trying to keep everything equally important.</li><li>Letting others’ urgency define your priorities.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • June 24</div>
          <div class="day-tag">Money Strategy</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions about long-term money may surface; this is a planning opportunity.</p>
        <div class="label">Spiritual</div>
        <p>Spirit supports crafting a simple H2 money strategy linked to your priorities.</p>
        <div class="label">Financial</div>
        <p>Good for naming income targets, savings goals, or debt plans for the next six months.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Define one primary money focus (e.g., stabilize, grow, pay down, invest) for H2.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Align money plans with your values and energy.</li><li>Keep the plan simple enough that you’ll actually follow it.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Creating an extremely detailed plan you’ll never look at again.</li><li>Basing all decisions on fear scenarios.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • June 25</div>
          <div class="day-tag">Support & Mentoring</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you might feel ready to seek more structured support or guidance.</p>
        <div class="label">Spiritual</div>
        <p>Spirit may highlight teachers, mentors, or peers whose wisdom fits your next level.</p>
        <div class="label">Financial</div>
        <p>Good for considering coaching, training, or peer support structures for H2.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Identify 1–3 people or resources that could support your growth and take one small step toward them.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let yourself be guided where it feels right.</li><li>Choose support sources aligned with your values.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Assuming you must figure everything out alone.</li><li>Collecting courses or mentors without committing to any.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Fri • June 26</div>
          <div class="day-tag">Community & Belonging</div>
        </div>
        <div class="label">Emotional</div>
        <p>You feel into where you truly belong and where you’ve been forcing it.</p>
        <div class="label">Spiritual</div>
        <p>Spirit encourages you to move toward spaces that feel like home for your evolving self.</p>
        <div class="label">Financial</div>
        <p>Light money focus; more about community alignment.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Note which spaces (online or offline) feel like your future, and which feel like your past.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Move closer to communities that nourish you.</li><li>Give yourself permission to outgrow old rooms.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Staying in misaligned spaces for nostalgia.</li><li>Shrinking to fit into groups you’ve outgrown.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sat • June 27</div>
          <div class="day-tag">Month-End Cleanup</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you want to wrap things up so July feels like a fresh chapter.</p>
        <div class="label">Spiritual</div>
        <p>Spirit supports practical completion and physical tidying.</p>
        <div class="label">Financial</div>
        <p>Ideal for clearing workspaces, files, and lingering tasks.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Do a 30–60 minute “H2 prep clean” in your physical or digital environment.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Create physical evidence of a reset.</li><li>Let go of what you don’t need to carry forward.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Letting piles and clutter grow indefinitely.</li><li>Holding onto projects you know you’ll never finish.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sun • June 28</div>
          <div class="day-tag">Gratitude for H1</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions soften into gratitude as you look back on everything H1 asked of you.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to bless the first half of the year, including its difficulties.</p>
        <div class="label">Financial</div>
        <p>Good for a reflective gratitude practice that honors the full spectrum of experience.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write: “Three ways the first half of 2026 made me stronger,” even if some were tough.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Honor your resilience and adaptability.</li><li>Let gratitude be nuanced and honest.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Only feeling grateful for easy things.</li><li>Skipping reflection because some parts were hard.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • June 29</div>
          <div class="day-tag">Ritual of Commitment</div>
        </div>
        <div class="label">Emotional</div>
        <p>You feel ready to make some inner vows about how you’ll show up in H2.</p>
        <div class="label">Spiritual</div>
        <p>Spirit supports simple, powerful commitments over complicated resolutions.</p>
        <div class="label">Financial</div>
        <p>Good for short, clear statements of how you’ll treat yourself and your path.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write 2–3 sentences starting with “In the second half of 2026, I commit to…”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let these commitments be heart-level, not just task-level.</li><li>Keep them visible somewhere meaningful.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Creating a long list you’ll forget.</li><li>Making commitments you don’t actually want.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • June 30</div>
          <div class="day-tag">Closing & Blessing</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you stand at the doorway between halves of the year.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to bless what’s behind and what’s ahead.</p>
        <div class="label">Financial</div>
        <p>Perfect for a mid-year closing ritual—like a mini New Year’s moment.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Light a candle, speak aloud what you’re leaving in H1, and bless what you’re inviting into H2.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Treat today as a sacred hinge.</li><li>Allow yourself to feel both relief and anticipation.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Rushing past this midpoint without acknowledgment.</li><li>Dragging old stories forward by default.</li>
            </ul>
          </div>
        </div>
      </article>
    
    </section>
  </div>
</body>
</html>
