
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>June 15–21, 2026 • Weekly Destiny View</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #0b0d10;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1100px;
      margin: 0 auto;
      padding: 24px 16px 48px;
    }

    a {
      color: var(--accent);
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    header {
      margin-bottom: 18px;
    }

    .back-link {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      display: inline-flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 10px;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 1.7rem;
      letter-spacing: 0.06em;
      text-transform: uppercase;
    }

    .subtitle {
      font-size: 0.95rem;
      color: var(--muted);
      margin-top: 4px;
    }

    .week-meta {
      margin-top: 10px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
    }

    .pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      color: var(--muted);
      background: rgba(0, 0, 0, 0.3);
    }

    .pill strong {
      color: var(--accent);
    }

    .days-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
      margin-top: 20px;
    }

    .day-card {
      background: var(--card-bg);
      border-radius: 16px;
      padding: 10px 12px;
      border: 1px solid var(--border);
      box-shadow: 0 10px 22px rgba(0, 0, 0, 0.45);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .day-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      margin-bottom: 4px;
    }

    .day-name {
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .day-tag {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-top: 4px;
      margin-bottom: 2px;
    }

    .day-card p {
      margin: 3px 0 5px;
    }

    .bullet-list {
      padding-left: 16px;
      margin: 2px 0 4px;
    }

    .bullet-list li {
      margin-bottom: 3px;
    }

    .ritual {
      margin-top: 4px;
      padding: 5px 7px;
      border-radius: 10px;
      border: 1px dashed var(--border);
      background: rgba(0, 0, 0, 0.25);
      font-size: 0.86rem;
    }

    .ritual strong {
      color: var(--accent);
    }

    .do-avoid {
      display: flex;
      gap: 8px;
      margin-top: 4px;
      font-size: 0.8rem;
    }

    .do-avoid div {
      flex: 1;
    }

    .do-avoid b {
      display: block;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      font-size: 0.7rem;
      margin-bottom: 1px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.4rem;
      }
    }
  </style>
</head>
<body>
  <div class="page">
    <header>
      <a href="../index.php" class="back-link">← Back to Home</a>
      <h1>Week 3 • June 15–21, 2026</h1>
      <div class="subtitle">
        Emotional Integration • Letting feelings catch up with all the changes you’ve made.
      </div>
      <div class="week-meta">
        <div class="pill"><strong>Week Focus:</strong> Debrief, compassion, and choosing new emotional patterns.</div>
        <div class="pill"><strong>Best Use:</strong> Journaling, conversations, and money-emotion healing.</div>
      </div>
    </header>

    <section class="days-grid">
      
      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • June 15</div>
          <div class="day-tag">Emotional Debrief</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you feel ready to name what the first half of the year has really felt like.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites honest emotional debriefing so nothing gets stuck under the surface.</p>
        <div class="label">Financial</div>
        <p>Light work; prioritize journaling or talking things out.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write: “The emotional story of my year so far is…” and let yourself free-write.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let your feelings be seen and heard.</li><li>Validate your own experience without minimizing it.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Polishing your narrative to sound better than it felt.</li><li>Shoving down feelings to “stay positive.”</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • June 16</div>
          <div class="day-tag">Compassion Upgrade</div>
        </div>
        <div class="label">Emotional</div>
        <p>You may feel tenderness or regret about choices made under old patterns.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites a deeper level of self-compassion as you integrate and grow.</p>
        <div class="label">Financial</div>
        <p>Not a big money day; focus on how you speak to yourself about the past.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Notice one area where you’ve been hard on yourself and deliberately soften your internal language.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Talk to yourself like someone you love.</li><li>Let yourself be a learner, not a finished product.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Beating yourself up for not knowing then what you know now.</li><li>Treating compassion as a weakness.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • June 17</div>
          <div class="day-tag">Heart Alignment</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions and heart wisdom are aligned today; decisions from this place ring true.</p>
        <div class="label">Spiritual</div>
        <p>Spirit encourages you to choose paths that feel congruent in heart, mind, and body.</p>
        <div class="label">Financial</div>
        <p>Good for making or confirming decisions that directly affect your emotional life.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Ask your heart three times about a key decision: “Does this feel like love toward myself and my future?”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let your heart have a real vote.</li><li>Be willing to slow decisions until you feel clarity.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Making choices solely to impress others.</li><li>Ignoring a dull ache that says “this isn’t it.”</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • June 18</div>
          <div class="day-tag">Money & Emotion</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions about money may peak—this is a chance to heal some of that charge.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to separate your worth from your numbers more deeply.</p>
        <div class="label">Financial</div>
        <p>Good for noticing emotional patterns around spending, earning, and saving.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Ask: “When I look at money, what feeling arises first?” Then explore where that feeling began.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let curiosity, not shame, guide your exploration.</li><li>Choose one small compassionate money action today.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Punishing yourself for past money choices.</li><li>Avoiding money entirely to escape discomfort.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Fri • June 19</div>
          <div class="day-tag">Connection & Sharing</div>
        </div>
        <div class="label">Emotional</div>
        <p>You may feel drawn to share your emotional journey with someone safe.</p>
        <div class="label">Spiritual</div>
        <p>Spirit supports healing conversations and mutual vulnerability.</p>
        <div class="label">Financial</div>
        <p>Light money focus; better for emotional honesty with trusted people.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Share one piece of your inner process with someone who has earned that trust.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let yourself be supported emotionally.</li><li>Allow others’ stories to remind you you’re not alone.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Oversharing with people who haven’t earned intimacy.</li><li>Isolating yourself when you want connection.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sat • June 20</div>
          <div class="day-tag">Rest & Soft Joy</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, simple pleasures land more deeply today.</p>
        <div class="label">Spiritual</div>
        <p>Spirit reminds you that small joys heal micro-fractures in your spirit.</p>
        <div class="label">Financial</div>
        <p>Minimal work; focus on softness, comfort, and ease.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Do one gentle, joy-giving activity with full presence (no multitasking).
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let joy be quiet and real.</li><li>Notice that peace also counts as an emotion worth cultivating.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Turning joy into a productivity contest.</li><li>Feeling guilty for relaxing when there’s work to do.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sun • June 21</div>
          <div class="day-tag">Integration Threshold</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions settle; you sense you’re at a threshold between old emotional patterns and new ones.</p>
        <div class="label">Spiritual</div>
        <p>Spirit encourages you to consciously choose which patterns to carry forward.</p>
        <div class="label">Financial</div>
        <p>Good for writing or ritual that marks the end of a particular emotional era.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write: “Emotional patterns I’m retiring now…” and name them clearly.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Choose to walk differently into H2.</li><li>Honor the version of you that got you this far.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Dragging old emotional loops into new chapters.</li><li>Pretending you can outrun your feelings without processing them.</li>
            </ul>
          </div>
        </div>
      </article>
    
    </section>
  </div>
</body>
</html>
