
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>June 8–14, 2026 • Weekly Destiny View</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #0b0d10;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1100px;
      margin: 0 auto;
      padding: 24px 16px 48px;
    }

    a {
      color: var(--accent);
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    header {
      margin-bottom: 18px;
    }

    .back-link {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      display: inline-flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 10px;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 1.7rem;
      letter-spacing: 0.06em;
      text-transform: uppercase;
    }

    .subtitle {
      font-size: 0.95rem;
      color: var(--muted);
      margin-top: 4px;
    }

    .week-meta {
      margin-top: 10px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
    }

    .pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      color: var(--muted);
      background: rgba(0, 0, 0, 0.3);
    }

    .pill strong {
      color: var(--accent);
    }

    .days-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
      margin-top: 20px;
    }

    .day-card {
      background: var(--card-bg);
      border-radius: 16px;
      padding: 10px 12px;
      border: 1px solid var(--border);
      box-shadow: 0 10px 22px rgba(0, 0, 0, 0.45);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .day-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      margin-bottom: 4px;
    }

    .day-name {
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .day-tag {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-top: 4px;
      margin-bottom: 2px;
    }

    .day-card p {
      margin: 3px 0 5px;
    }

    .bullet-list {
      padding-left: 16px;
      margin: 2px 0 4px;
    }

    .bullet-list li {
      margin-bottom: 3px;
    }

    .ritual {
      margin-top: 4px;
      padding: 5px 7px;
      border-radius: 10px;
      border: 1px dashed var(--border);
      background: rgba(0, 0, 0, 0.25);
      font-size: 0.86rem;
    }

    .ritual strong {
      color: var(--accent);
    }

    .do-avoid {
      display: flex;
      gap: 8px;
      margin-top: 4px;
      font-size: 0.8rem;
    }

    .do-avoid div {
      flex: 1;
    }

    .do-avoid b {
      display: block;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      font-size: 0.7rem;
      margin-bottom: 1px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.4rem;
      }
    }
  </style>
</head>
<body>
  <div class="page">
    <header>
      <a href="../index.php" class="back-link">← Back to Home</a>
      <h1>Week 2 • June 8–14, 2026</h1>
      <div class="subtitle">
        Re-Tuning Systems • Making your structures fit who you’re becoming, not who you were.
      </div>
      <div class="week-meta">
        <div class="pill"><strong>Week Focus:</strong> Auditing and simplifying your systems for H2.</div>
        <div class="pill"><strong>Best Use:</strong> Task streamlining, communication norms, and money mechanics.</div>
      </div>
    </header>

    <section class="days-grid">
      
      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • June 8</div>
          <div class="day-tag">System Audit</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally pragmatic; you can see what’s clunky in your systems without drama.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to treat your systems like instruments being tuned for H2.</p>
        <div class="label">Financial</div>
        <p>Good for listing which tools, workflows, and habits actually serve you.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write down your core systems (money, tasks, communication) and give each a simple score from 1–10.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Identify which system needs the most support.</li><li>Commit to one upgrade project at a time.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Trying to overhaul everything at once.</li><li>Sticking with broken systems just because they’re familiar.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • June 9</div>
          <div class="day-tag">Task Streamlining</div>
        </div>
        <div class="label">Emotional</div>
        <p>You feel ready to simplify; unnecessary steps irritate you more than usual.</p>
        <div class="label">Spiritual</div>
        <p>Spirit encourages ruthless kindness: make life easier for future you.</p>
        <div class="label">Financial</div>
        <p>Ideal for cutting steps, automating micro-tasks, or delegating where possible.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Choose one recurring task and ask: “How can I make this 30% easier?” Implement that.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Design work so it flows instead of clogs.</li><li>Eliminate at least one unnecessary step in a process.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Accepting friction as inevitable.</li><li>Doing everything manually when a tiny tweak would help.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • June 10</div>
          <div class="day-tag">Communication Tune-Up</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you feel where miscommunications or delays have cost energy.</p>
        <div class="label">Spiritual</div>
        <p>Spirit nudges you to clarify how and when people can reach you—and what they can expect.</p>
        <div class="label">Financial</div>
        <p>Good for updating communication norms (response times, channels, boundaries).</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write a short “here’s how to work with me” note for collaborators or clients, even if you only share it with yourself for now.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Create clearer expectations that protect your energy.</li><li>Tweak auto-replies or welcome messages if you use them.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Leaving others guessing about your availability.</li><li>Saying yes faster than you can realistically respond.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • June 11</div>
          <div class="day-tag">Money Mechanisms</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions around money, billing, and receiving may feel louder today.</p>
        <div class="label">Spiritual</div>
        <p>Spirit encourages smoother mechanisms: how money actually moves to you.</p>
        <div class="label">Financial</div>
        <p>Good for checking payment methods, invoicing systems, and pricing structures.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Ask: “Is it easy and clear for money to reach me?” and improve one bottleneck.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Make paying you simple and straightforward.</li><li>Clarify terms in writing where helpful.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Complicated or hidden pricing.</li><li>Delaying invoicing because it feels uncomfortable.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Fri • June 12</div>
          <div class="day-tag">Support Scan</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you sense where you try to “do it all” vs. where support would help.</p>
        <div class="label">Spiritual</div>
        <p>Spirit reminds you that systems can include people, not just tools.</p>
        <div class="label">Financial</div>
        <p>Light money focus; more about emotional and practical support structures.</p>
        <div class="ritual">
          <strong>Ritual:</strong> List ways you could receive more support (paid or unpaid) and pick one micro-step toward it.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Consider small forms of support you’ve overlooked.</li><li>Open to the idea that you don't have to carry everything.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Wearing self-reliance as armor.</li><li>Assuming no one can help you effectively.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sat • June 13</div>
          <div class="day-tag">Sabbath for Systems</div>
        </div>
        <div class="label">Emotional</div>
        <p>Your emotions may need a break from “fixing” mode; over-optimization is tiring.</p>
        <div class="label">Spiritual</div>
        <p>Spirit encourages a rest-from-optimization so your nervous system can relax.</p>
        <div class="label">Financial</div>
        <p>Minimal work; step away from tinkering and let things breathe.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Spend time doing something that has no productivity goal at all.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Detach from improvement mode for a day.</li><li>Let fun and rest exist without justification.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Tweaking tools all day long.</li><li>Judging yourself for not optimizing every moment.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sun • June 14</div>
          <div class="day-tag">Integration & Insight</div>
        </div>
        <div class="label">Emotional</div>
        <p>A calmer emotional tone lets insights about your systems emerge naturally.</p>
        <div class="label">Spiritual</div>
        <p>Spirit connects dots between habits, tools, and how you actually feel.</p>
        <div class="label">Financial</div>
        <p>Good for summarizing what system changes matter most for H2.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write a short “system manifesto” describing how you want your work and life to feel structurally.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let this manifesto guide future decisions.</li><li>Choose one system upgrade to complete by month’s end.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Letting tools dictate how you live.</li><li>Ignoring your preferences when designing workflows.</li>
            </ul>
          </div>
        </div>
      </article>
    
    </section>
  </div>
</body>
</html>
