
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>June 1–7, 2026 • Weekly Destiny View</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #0b0d10;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1100px;
      margin: 0 auto;
      padding: 24px 16px 48px;
    }

    a {
      color: var(--accent);
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    header {
      margin-bottom: 18px;
    }

    .back-link {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      display: inline-flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 10px;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 1.7rem;
      letter-spacing: 0.06em;
      text-transform: uppercase;
    }

    .subtitle {
      font-size: 0.95rem;
      color: var(--muted);
      margin-top: 4px;
    }

    .week-meta {
      margin-top: 10px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
    }

    .pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      color: var(--muted);
      background: rgba(0, 0, 0, 0.3);
    }

    .pill strong {
      color: var(--accent);
    }

    .days-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
      margin-top: 20px;
    }

    .day-card {
      background: var(--card-bg);
      border-radius: 16px;
      padding: 10px 12px;
      border: 1px solid var(--border);
      box-shadow: 0 10px 22px rgba(0, 0, 0, 0.45);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .day-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      margin-bottom: 4px;
    }

    .day-name {
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .day-tag {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-top: 4px;
      margin-bottom: 2px;
    }

    .day-card p {
      margin: 3px 0 5px;
    }

    .bullet-list {
      padding-left: 16px;
      margin: 2px 0 4px;
    }

    .bullet-list li {
      margin-bottom: 3px;
    }

    .ritual {
      margin-top: 4px;
      padding: 5px 7px;
      border-radius: 10px;
      border: 1px dashed var(--border);
      background: rgba(0, 0, 0, 0.25);
      font-size: 0.86rem;
    }

    .ritual strong {
      color: var(--accent);
    }

    .do-avoid {
      display: flex;
      gap: 8px;
      margin-top: 4px;
      font-size: 0.8rem;
    }

    .do-avoid div {
      flex: 1;
    }

    .do-avoid b {
      display: block;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      font-size: 0.7rem;
      margin-bottom: 1px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.4rem;
      }
    }
  </style>
</head>
<body>
  <div class="page">
    <header>
      <a href="../index.php" class="back-link">← Back to Home</a>
      <h1>Week 1 • June 1–7, 2026</h1>
      <div class="subtitle">
        Mid-Year Mirror • Seeing the first half of Year 5 as a coherent arc and re-anchoring.
      </div>
      <div class="week-meta">
        <div class="pill"><strong>Week Focus:</strong> Review, emotional inventory, spiritual and financial snapshots.</div>
        <div class="pill"><strong>Best Use:</strong> Mapping H1, listening to your emotions, and naming H2 themes.</div>
      </div>
    </header>

    <section class="days-grid">
      
      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • June 1</div>
          <div class="day-tag">Mid-Year Mirror</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you feel aware that 2026 is nearly halfway through; perspective widens.</p>
        <div class="label">Spiritual</div>
        <p>Spirit asks you to look at the first half of the year as a coherent story, not random events.</p>
        <div class="label">Financial</div>
        <p>Good for reviewing how your Year 5 expansion arc has unfolded so far.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write a quick timeline of key events since January and note what patterns you see.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Zoom out and see the bigger story.</li><li>Acknowledge how much you’ve navigated already.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Treating each month like an isolated failure or success.</li><li>Ignoring your own resilience.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • June 2</div>
          <div class="day-tag">Emotional Inventory</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions today highlight which areas feel unresolved or overloaded.</p>
        <div class="label">Spiritual</div>
        <p>Spirit encourages gentle honesty about what’s emotionally expensive in your life.</p>
        <div class="label">Financial</div>
        <p>Light work; better for taking stock than for heavy decisions.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Make three columns: “Draining,” “Neutral,” and “Nourishing” for your main activities.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Be honest without judging yourself.</li><li>Identify one draining thing you’d like to change in H2.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Pretending everything is fine when it’s not.</li><li>Assuming you must tolerate constant drain.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • June 3</div>
          <div class="day-tag">Spiritual Re-Anchor</div>
        </div>
        <div class="label">Emotional</div>
        <p>You feel a pull back to practices or beliefs that ground you deeply.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to refresh or update your spiritual routine for the second half of the year.</p>
        <div class="label">Financial</div>
        <p>Good for revisiting rituals, prayer, meditation, or contemplative practices.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Return to one practice that used to ground you—or start a simpler version of one now.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let spiritual grounding precede big decisions.</li><li>Simplify your practices so they’re easier to maintain.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Waiting for the “perfect” ritual to begin.</li><li>Treating spiritual life as an afterthought.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • June 4</div>
          <div class="day-tag">Money Snapshot</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions around money today feel sharper but also more informative.</p>
        <div class="label">Spiritual</div>
        <p>Spirit supports a clean, data-driven look at your financial year-to-date.</p>
        <div class="label">Financial</div>
        <p>Ideal for reviewing income, expenses, and debt for Jan–May combined.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Create a simple year-to-date money snapshot and label it “Information, not judgment.”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Use numbers to inform, not shame.</li><li>Choose one financial focus for June that supports the bigger arc.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Panicking at the sight of totals.</li><li>Avoiding helpful conversations or resources.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Fri • June 5</div>
          <div class="day-tag">Identity Glimpse</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you glimpse who you’re becoming through all this expansion.</p>
        <div class="label">Spiritual</div>
        <p>Spirit offers flashes of your “next-level” self—how they move, decide, and rest.</p>
        <div class="label">Financial</div>
        <p>Good for updating how you describe yourself and your role.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write a short paragraph as if you’re already living from your next-level identity.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let that future-self voice advise you today.</li><li>Make one choice that version of you would make.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Insisting you haven’t changed at all.</li><li>Downplaying your evolution to keep others comfortable.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sat • June 6</div>
          <div class="day-tag">Nervous System Care</div>
        </div>
        <div class="label">Emotional</div>
        <p>You may feel a bit raw from looking at the big picture; care is needed.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to let your system digest what you’ve been reviewing.</p>
        <div class="label">Financial</div>
        <p>Minimal work; prioritize grounding, pleasure, and rest.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Do one simple ritual: bath, walk, tea, or creative play, dedicating it to your mid-year integration.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let your body catch up to your insights.</li><li>Say no to obligations that feel optional today.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Overloading the day with tasks.</li><li>Using stimulants to override tiredness.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sun • June 7</div>
          <div class="day-tag">Intentional Aim</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions are calmer; you’re ready to aim the rest of the year more consciously.</p>
        <div class="label">Spiritual</div>
        <p>Spirit asks: “What do you want the second half of 2026 to be about?”</p>
        <div class="label">Financial</div>
        <p>Good for naming 2–3 guiding themes or intentions for the rest of the year.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write three words you want to define your next six months and place them where you’ll see them often.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let those words inform your upcoming choices.</li><li>Keep intentions simple and resonant.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Creating a huge, rigid plan instead of themes.</li><li>Choosing words that sound good but don’t feel real.</li>
            </ul>
          </div>
        </div>
      </article>
    
    </section>
  </div>
</body>
</html>
