
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>May 8–14, 2026 • Weekly Destiny View</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #0b0d10;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1100px;
      margin: 0 auto;
      padding: 24px 16px 48px;
    }

    a {
      color: var(--accent);
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    header {
      margin-bottom: 18px;
    }

    .back-link {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      display: inline-flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 10px;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 1.7rem;
      letter-spacing: 0.06em;
      text-transform: uppercase;
    }

    .subtitle {
      font-size: 0.95rem;
      color: var(--muted);
      margin-top: 4px;
    }

    .week-meta {
      margin-top: 10px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
    }

    .pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      color: var(--muted);
      background: rgba(0, 0, 0, 0.3);
    }

    .pill strong {
      color: var(--accent);
    }

    .days-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
      margin-top: 20px;
    }

    .day-card {
      background: var(--card-bg);
      border-radius: 16px;
      padding: 10px 12px;
      border: 1px solid var(--border);
      box-shadow: 0 10px 22px rgba(0, 0, 0, 0.45);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .day-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      margin-bottom: 4px;
    }

    .day-name {
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .day-tag {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-top: 4px;
      margin-bottom: 2px;
    }

    .day-card p {
      margin: 3px 0 5px;
    }

    .bullet-list {
      padding-left: 16px;
      margin: 2px 0 4px;
    }

    .bullet-list li {
      margin-bottom: 3px;
    }

    .ritual {
      margin-top: 4px;
      padding: 5px 7px;
      border-radius: 10px;
      border: 1px dashed var(--border);
      background: rgba(0, 0, 0, 0.25);
      font-size: 0.86rem;
    }

    .ritual strong {
      color: var(--accent);
    }

    .do-avoid {
      display: flex;
      gap: 8px;
      margin-top: 4px;
      font-size: 0.8rem;
    }

    .do-avoid div {
      flex: 1;
    }

    .do-avoid b {
      display: block;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      font-size: 0.7rem;
      margin-bottom: 1px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.4rem;
      }
    }
  </style>
</head>
<body>
  <div class="page">
    <header>
      <a href="../index.php" class="back-link">← Back to Home</a>
      <h1>Week 2 • May 8–14, 2026</h1>
      <div class="subtitle">
        Rhythms of Outreach • Building sustainable, human connection patterns instead of sporadic blasts.
      </div>
      <div class="week-meta">
        <div class="pill"><strong>Week Focus:</strong> Outreach habits, relationships, and value stories.</div>
        <div class="pill"><strong>Best Use:</strong> Mapping your network, refining stories, and practicing confident sharing.</div>
      </div>
    </header>

    <section class="days-grid">
      
      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Fri • May 8</div>
          <div class="day-tag">Outreach Rhythm</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you sense that sporadic, intense outreach isn’t as effective as steady touchpoints.</p>
        <div class="label">Spiritual</div>
        <p>Spirit supports simple, repeatable outreach patterns over heroic bursts.</p>
        <div class="label">Financial</div>
        <p>Great for designing a weekly outreach or follow-up rhythm.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Decide how many people you’ll reach out to each week and put gentle reminders in your calendar.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Create a sustainable outreach habit.</li><li>Start with a small, doable commitment.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Trying to contact 50 people in a day, then crashing.</li><li>Leaving outreach to chance whenever you “feel like it.”</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sat • May 9</div>
          <div class="day-tag">Relationship Mapping</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally more relational; you see clearly who feels energizing vs. draining.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to place your time where mutual respect and resonance live.</p>
        <div class="label">Financial</div>
        <p>Not a heavy money day; focus on mapping your relational ecosystem.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Sketch your current network and mark who you’d love to deepen connection with this year.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Nurture relationships that feel reciprocal and inspiring.</li><li>Let a few draining ties quietly fade.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Trying to maintain intense contact with everyone.</li><li>Keeping yourself in spaces that don’t value you.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sun • May 10</div>
          <div class="day-tag">Inner Stories</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions today reveal the stories you tell yourself about being visible, successful, or paid.</p>
        <div class="label">Spiritual</div>
        <p>Spirit asks: “Whose voice are you hearing when you hesitate?”</p>
        <div class="label">Financial</div>
        <p>Light work; focus on unearthing and questioning old narratives.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write the sentence: “I can’t be fully seen because…” then challenge each reason you list.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Name old stories clearly.</li><li>Replace at least one old belief with a more generous one.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Letting inherited beliefs make your decisions.</li><li>Assuming fear means you’re not ready.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • May 11</div>
          <div class="day-tag">Confident Sharing</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally more grounded; you can share from a place of genuine confidence today.</p>
        <div class="label">Spiritual</div>
        <p>Spirit boosts messages that center service and truth rather than performance.</p>
        <div class="label">Financial</div>
        <p>Ideal for a more visible share: newsletter, live, or post explaining your core work.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Share one piece of content that clearly states who you help and how you help them.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Speak plainly and proudly about your work.</li><li>Allow your natural voice to come through.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Overthinking every word until you never send it.</li><li>Trying to mimic someone else’s tone.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • May 12</div>
          <div class="day-tag">Feedback Filters</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you may feel sensitive to how people respond—or don’t respond—to your efforts.</p>
        <div class="label">Spiritual</div>
        <p>Spirit reminds you that not all feedback is equal; some voices matter more than others.</p>
        <div class="label">Financial</div>
        <p>Good for deciding whose feedback you actually care about.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Make a short list of “people whose input counts” and ignore random opinions outside that circle.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let trusted feedback shape your evolution.</li><li>Notice who consistently understands your intent.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Letting strangers’ comments derail you.</li><li>Chasing validation from people who don’t get your work.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • May 13</div>
          <div class="day-tag">Money & Value</div>
        </div>
        <div class="label">Emotional</div>
        <p>Money conversations may feel charged but important; value is the theme.</p>
        <div class="label">Spiritual</div>
        <p>Spirit encourages you to align your prices and asks with the real value you deliver.</p>
        <div class="label">Financial</div>
        <p>Good for reviewing pricing, payment terms, or how you talk about value.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Ask yourself: “If I believed fully in my value, what would I charge or request here?”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Adjust one price, term, or boundary closer to your true value.</li><li>Practice saying your price calmly out loud.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Undercharging out of fear.</li><li>Overexplaining your rates to justify them.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • May 14</div>
          <div class="day-tag">Integration & Pause</div>
        </div>
        <div class="label">Emotional</div>
        <p>Your emotional field wants a softer day after relational and visibility pushes.</p>
        <div class="label">Spiritual</div>
        <p>Spirit uses quieter moments to weave insights together.</p>
        <div class="label">Financial</div>
        <p>Minimal money/work; review what’s shifted in your sense of value and visibility.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write three observations about how your relationship to being seen has changed this month.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let the nervous system catch up with your new level.</li><li>Acknowledge how far you’ve come in outreach comfort.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Pushing new initiatives without rest.</li><li>Demanding overnight transformation from yourself.</li>
            </ul>
          </div>
        </div>
      </article>
    
    </section>
  </div>
</body>
</html>
