
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>April 22–30, 2026 • Weekly Destiny View</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #0b0d10;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1100px;
      margin: 0 auto;
      padding: 24px 16px 48px;
    }

    a {
      color: var(--accent);
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    header {
      margin-bottom: 18px;
    }

    .back-link {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      display: inline-flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 10px;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 1.7rem;
      letter-spacing: 0.06em;
      text-transform: uppercase;
    }

    .subtitle {
      font-size: 0.95rem;
      color: var(--muted);
      margin-top: 4px;
    }

    .week-meta {
      margin-top: 10px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
    }

    .pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      color: var(--muted);
      background: rgba(0, 0, 0, 0.3);
    }

    .pill strong {
      color: var(--accent);
    }

    .days-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
      margin-top: 20px;
    }

    .day-card {
      background: var(--card-bg);
      border-radius: 16px;
      padding: 10px 12px;
      border: 1px solid var(--border);
      box-shadow: 0 10px 22px rgba(0, 0, 0, 0.45);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .day-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      margin-bottom: 4px;
    }

    .day-name {
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .day-tag {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-top: 4px;
      margin-bottom: 2px;
    }

    .day-card p {
      margin: 3px 0 5px;
    }

    .bullet-list {
      padding-left: 16px;
      margin: 2px 0 4px;
    }

    .bullet-list li {
      margin-bottom: 3px;
    }

    .ritual {
      margin-top: 4px;
      padding: 5px 7px;
      border-radius: 10px;
      border: 1px dashed var(--border);
      background: rgba(0, 0, 0, 0.25);
      font-size: 0.86rem;
    }

    .ritual strong {
      color: var(--accent);
    }

    .do-avoid {
      display: flex;
      gap: 8px;
      margin-top: 4px;
      font-size: 0.8rem;
    }

    .do-avoid div {
      flex: 1;
    }

    .do-avoid b {
      display: block;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      font-size: 0.7rem;
      margin-bottom: 1px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.4rem;
      }
    }
  </style>
</head>
<body>
  <div class="page">
    <header>
      <a href="../index.php" class="back-link">← Back to Home</a>
      <h1>Week 4 • April 22–30, 2026</h1>
      <div class="subtitle">
        Stabilizing Changes • Making sure your Q2 upgrades are sustainable and integrated.
      </div>
      <div class="week-meta">
        <div class="pill"><strong>Week Focus:</strong> Sustainability, money grounding, and month-end closure.</div>
        <div class="pill"><strong>Best Use:</strong> Refining routines, checking finances, community tending, and closing April with ritual.</div>
      </div>
    </header>

    <section class="days-grid">
      
      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • April 22</div>
          <div class="day-tag">Stability Check</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you notice which changes feel sustainable and which feel precarious.</p>
        <div class="label">Spiritual</div>
        <p>Spirit wants your upgrades to be livable, not just impressive on paper.</p>
        <div class="label">Financial</div>
        <p>Good for adjusting routines or agreements to be more sustainable.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Ask: “Could I keep doing this for six months?” If not, adjust the pace or scope.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Tune your life toward long-term sustainability.</li><li>Simplify one routine so it’s easier to maintain.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Clinging to unsustainable intensity.</li><li>Ignoring early signs of burnout.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • April 23</div>
          <div class="day-tag">Money Grounding</div>
        </div>
        <div class="label">Emotional</div>
        <p>Money feelings may surface—excitement, worry, or both.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to ground by facing numbers with compassion and clarity.</p>
        <div class="label">Financial</div>
        <p>Ideal for reviewing April income, expenses, and early Q2 trends.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Have a money date: open accounts, review key numbers, and note one small improvement from last month.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Treat numbers as information, not identity.</li><li>Choose one next right money action.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Avoiding your accounts out of fear.</li><li>Making big impulsive purchases to soothe stress.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Fri • April 24</div>
          <div class="day-tag">Community Weaving</div>
        </div>
        <div class="label">Emotional</div>
        <p>You may feel more sociable, drawn to strengthening your web of support.</p>
        <div class="label">Spiritual</div>
        <p>Your soul reminds you that the right community multiplies your efforts.</p>
        <div class="label">Financial</div>
        <p>Great for reconnecting with peers, collaborators, or mentors.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Reach out to someone whose presence steadies or inspires you and share a brief update.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Invest in relationships that feel mutual.</li><li>Allow yourself to receive support, not just give it.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Staying isolated out of habit.</li><li>Pouring energy into connections that never reciprocate.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sat • April 25</div>
          <div class="day-tag">Nervous System Sabbath</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, your system wants a real pause; subtle stress might have accumulated.</p>
        <div class="label">Spiritual</div>
        <p>Spirit frames today as a mini-sabbath to reset your baseline.</p>
        <div class="label">Financial</div>
        <p>Minimal money/work; focus on nervous-system-friendly activities.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Take a day (or half-day) largely offline from heavy inputs. Let your brain idle.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let yourself be “off-duty” for a while.</li><li>Notice how creativity returns when you stop forcing it.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Bingeing stressful content.</li><li>Using caffeine to power through instead of resting.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sun • April 26</div>
          <div class="day-tag">Spiritual Review</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally reflective; you sense deeper lessons under this month’s events.</p>
        <div class="label">Spiritual</div>
        <p>Spirit is ready to connect dots if you’re willing to listen.</p>
        <div class="label">Financial</div>
        <p>Good for journaling or meditation about April’s underlying themes.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Journal on: “If April were a teacher, what did it come to show me?”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Pull meaning from your experiences.</li><li>Let insight soften any self-criticism.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Labeling the month as “good” or “bad” without nuance.</li><li>Ignoring quiet realizations that keep returning.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • April 27</div>
          <div class="day-tag">Execution & Cleanup</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions steady; you feel capable of handling practical matters.</p>
        <div class="label">Spiritual</div>
        <p>Spirit supports tying up April’s loose ends to prepare for May’s fresh arc.</p>
        <div class="label">Financial</div>
        <p>Ideal for finishing outstanding tasks and sending last emails or invoices.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Choose 3–5 open loops and close as many as you can today.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Create a sense of completion structurally.</li><li>Tidy your project lists and workspace.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Starting new projects when old ones are half-done.</li><li>Leaving clutter as “tomorrow’s problem.”</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • April 28</div>
          <div class="day-tag">Gentle Appreciation</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally softer; you can see small ways life supported you this month.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to appreciate support—seen and unseen—so it can amplify.</p>
        <div class="label">Financial</div>
        <p>Light money/work; focus on gratitude and acknowledgment more than hustle.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write a list: “Ten ways I was supported in April,” including internal shifts.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let gratitude be specific and embodied.</li><li>Thank at least one person who impacted you this month.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Rushing past the month without appreciation.</li><li>Only noticing what didn’t happen.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • April 29</div>
          <div class="day-tag">Transition Prep</div>
        </div>
        <div class="label">Emotional</div>
        <p>You feel the hinge between April and May; a subtle anticipation builds.</p>
        <div class="label">Spiritual</div>
        <p>Spirit suggests preparing gently rather than cramming.</p>
        <div class="label">Financial</div>
        <p>Good for sketching May intentions and blocking key time in your calendar.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Note one thing you want more of and one thing you want less of in May.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Set simple, clear May intentions.</li><li>Align your schedule with your desired feelings.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Cluttering May with obligations you already dread.</li><li>Overplanning from anxiety rather than clarity.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • April 30</div>
          <div class="day-tag">Closing Ritual</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotional arc of the month comes into focus; you can feel what April changed in you.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to close this chapter with intention so May can start clean.</p>
        <div class="label">Financial</div>
        <p>Perfect for an end-of-month ritual blending money, emotion, and spirit.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Do a brief ritual: review your numbers, recall key moments, thank April aloud, and write one blessing for May.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Name and honor your April growth.</li><li>Let yourself feel complete with this month.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Dragging unresolved resentment into May.</li><li>Skipping reflection and immediately chasing the next goal.</li>
            </ul>
          </div>
        </div>
      </article>
    
    </section>
  </div>
</body>
</html>
