
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>April 15–21, 2026 • Weekly Destiny View</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #0b0d10;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1100px;
      margin: 0 auto;
      padding: 24px 16px 48px;
    }

    a {
      color: var(--accent);
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    header {
      margin-bottom: 18px;
    }

    .back-link {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      display: inline-flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 10px;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 1.7rem;
      letter-spacing: 0.06em;
      text-transform: uppercase;
    }

    .subtitle {
      font-size: 0.95rem;
      color: var(--muted);
      margin-top: 4px;
    }

    .week-meta {
      margin-top: 10px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
    }

    .pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      color: var(--muted);
      background: rgba(0, 0, 0, 0.3);
    }

    .pill strong {
      color: var(--accent);
    }

    .days-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
      margin-top: 20px;
    }

    .day-card {
      background: var(--card-bg);
      border-radius: 16px;
      padding: 10px 12px;
      border: 1px solid var(--border);
      box-shadow: 0 10px 22px rgba(0, 0, 0, 0.45);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .day-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      margin-bottom: 4px;
    }

    .day-name {
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .day-tag {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-top: 4px;
      margin-bottom: 2px;
    }

    .day-card p {
      margin: 3px 0 5px;
    }

    .bullet-list {
      padding-left: 16px;
      margin: 2px 0 4px;
    }

    .bullet-list li {
      margin-bottom: 3px;
    }

    .ritual {
      margin-top: 4px;
      padding: 5px 7px;
      border-radius: 10px;
      border: 1px dashed var(--border);
      background: rgba(0, 0, 0, 0.25);
      font-size: 0.86rem;
    }

    .ritual strong {
      color: var(--accent);
    }

    .do-avoid {
      display: flex;
      gap: 8px;
      margin-top: 4px;
      font-size: 0.8rem;
    }

    .do-avoid div {
      flex: 1;
    }

    .do-avoid b {
      display: block;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      font-size: 0.7rem;
      margin-bottom: 1px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.4rem;
      }
    }
  </style>
</head>
<body>
  <div class="page">
    <header>
      <a href="../index.php" class="back-link">← Back to Home</a>
      <h1>Week 3 • April 15–21, 2026</h1>
      <div class="subtitle">
        Deepening Commitment • Re-choosing priorities and aligning courage with strategy.
      </div>
      <div class="week-meta">
        <div class="pill"><strong>Week Focus:</strong> Mid-month truth-telling, recommitment, and strategic boldness.</div>
        <div class="pill"><strong>Best Use:</strong> Refining your Q2 focus, taking one courageous step, honoring joy and spirit.</div>
      </div>
    </header>

    <section class="days-grid">
      
      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • April 15</div>
          <div class="day-tag">Mid-Month Checkpoint</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you can sense whether Q2 is unfolding the way you hoped.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites honest assessment without self-attack: just noticing what is.</p>
        <div class="label">Financial</div>
        <p>Good for checking progress on your main project and money goals.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write a brief “mid-month status” note: what’s on track, what’s behind, what feels surprisingly good.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Adjust targets based on reality, not fantasy.</li><li>Celebrate at least one area of strong follow-through.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Ignoring clear data because it’s uncomfortable.</li><li>Shaming yourself for not being further ahead.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • April 16</div>
          <div class="day-tag">Re-Choosing</div>
        </div>
        <div class="label">Emotional</div>
        <p>Your emotions may ask: “Do I still choose this?” about one path or project.</p>
        <div class="label">Spiritual</div>
        <p>Your soul reminds you that you’re allowed to renew or revoke commitments consciously.</p>
        <div class="label">Financial</div>
        <p>Ideal day to recommit to what matters or gracefully exit what doesn’t.</p>
        <div class="ritual">
          <strong>Ritual:</strong> For each key project, ask: “If I were deciding today, would I still choose this?” Note your honest answer.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Re-choose what you want rather than drift.</li><li>Release one commitment that no longer feels true.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Staying in things purely out of inertia.</li><li>Forcing yourself to continue just to avoid discomfort.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Fri • April 17</div>
          <div class="day-tag">Strategic Courage</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally alert; you feel where a bit more courage would unlock a lot more movement.</p>
        <div class="label">Spiritual</div>
        <p>Spirit backs bold, focused moves in line with your Q2 theme.</p>
        <div class="label">Financial</div>
        <p>Good for making a meaningful ask, proposal, or decision you’ve delayed.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Identify one conversation or action you’ve been avoiding and take one concrete step toward it.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Frame courage as a gift to your future self.</li><li>Prepare briefly, then act before you overthink.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Waiting for “perfect timing.”</li><li>Assuming discomfort is a sign you’re wrong.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sat • April 18</div>
          <div class="day-tag">Integration & Pleasure</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you’re ready to soften after strategic pushes; pleasure recharges you.</p>
        <div class="label">Spiritual</div>
        <p>Spirit reminds you that joy is a fuel source, not a distraction.</p>
        <div class="label">Financial</div>
        <p>Minimal money/work; allow delight to seep into the day on purpose.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Do one thing purely because it brings you joy, then notice how your body responds.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let yourself feel good without guilt.</li><li>Notice how play boosts your creativity and resilience.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Turning pleasure into another productivity task.</li><li>Denying yourself joy until you “earn” it.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sun • April 19</div>
          <div class="day-tag">Spiritual Alignment</div>
        </div>
        <div class="label">Emotional</div>
        <p>You feel a deeper pull to connect with your own sense of meaning and guidance.</p>
        <div class="label">Spiritual</div>
        <p>Spirit is especially easy to hear today through quiet, ritual, or time in nature.</p>
        <div class="label">Financial</div>
        <p>Light planning: ensure your Q2 goals reflect your deeper values, not just money metrics.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Spend 10–15 minutes in silence and ask: “What do you want me to know about this quarter?” Write what comes.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let spiritual insight refine your practical plans.</li><li>Trust subtle messages, not just loud ones.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Dismissing intuitive hits as imagination.</li><li>Focusing only on numbers without soul context.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • April 20</div>
          <div class="day-tag">Execution Day</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally focused and capable; you’re primed to get real work done.</p>
        <div class="label">Spiritual</div>
        <p>Spirit supports practical action—many small tasks can click into place.</p>
        <div class="label">Financial</div>
        <p>Ideal for catching up on tasks that directly support income and stability.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Make a “Big Three” list and complete those before anything optional.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Channel your energy into clear, doable actions.</li><li>Keep your workspace simple to reduce friction.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Letting minor distractions steal your prime hours.</li><li>Starting many tasks without finishing them.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • April 21</div>
          <div class="day-tag">Gentle Closure</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally softer; you’re more aware of what this month has already shifted.</p>
        <div class="label">Spiritual</div>
        <p>Spirit encourages you to gently close micro-cycles so May can bring the next arc cleanly.</p>
        <div class="label">Financial</div>
        <p>Good for tying up loose ends related to your main Q2 focus.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Close at least one open loop (email thread, small invoice, tiny task) that’s been cluttering your mind.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Acknowledge the progress you can’t yet see on paper.</li><li>Let yourself feel “enough” for today.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Ending the day with dozens of half-finished tasks.</li><li>Demanding perfection from this month’s story.</li>
            </ul>
          </div>
        </div>
      </article>
    
    </section>
  </div>
</body>
</html>
