
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>April 8–14, 2026 • Weekly Destiny View</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #0b0d10;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1100px;
      margin: 0 auto;
      padding: 24px 16px 48px;
    }

    a {
      color: var(--accent);
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    header {
      margin-bottom: 18px;
    }

    .back-link {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      display: inline-flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 10px;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 1.7rem;
      letter-spacing: 0.06em;
      text-transform: uppercase;
    }

    .subtitle {
      font-size: 0.95rem;
      color: var(--muted);
      margin-top: 4px;
    }

    .week-meta {
      margin-top: 10px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
    }

    .pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      color: var(--muted);
      background: rgba(0, 0, 0, 0.3);
    }

    .pill strong {
      color: var(--accent);
    }

    .days-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
      margin-top: 20px;
    }

    .day-card {
      background: var(--card-bg);
      border-radius: 16px;
      padding: 10px 12px;
      border: 1px solid var(--border);
      box-shadow: 0 10px 22px rgba(0, 0, 0, 0.45);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .day-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      margin-bottom: 4px;
    }

    .day-name {
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .day-tag {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-top: 4px;
      margin-bottom: 2px;
    }

    .day-card p {
      margin: 3px 0 5px;
    }

    .bullet-list {
      padding-left: 16px;
      margin: 2px 0 4px;
    }

    .bullet-list li {
      margin-bottom: 3px;
    }

    .ritual {
      margin-top: 4px;
      padding: 5px 7px;
      border-radius: 10px;
      border: 1px dashed var(--border);
      background: rgba(0, 0, 0, 0.25);
      font-size: 0.86rem;
    }

    .ritual strong {
      color: var(--accent);
    }

    .do-avoid {
      display: flex;
      gap: 8px;
      margin-top: 4px;
      font-size: 0.8rem;
    }

    .do-avoid div {
      flex: 1;
    }

    .do-avoid b {
      display: block;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      font-size: 0.7rem;
      margin-bottom: 1px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.4rem;
      }
    }
  </style>
</head>
<body>
  <div class="page">
    <header>
      <a href="../index.php" class="back-link">← Back to Home</a>
      <h1>Week 2 • April 8–14, 2026</h1>
      <div class="subtitle">
        Flow & Structure • Adjusting your days so expansion feels smoother, not harsher.
      </div>
      <div class="week-meta">
        <div class="pill"><strong>Week Focus:</strong> Designing supportive rhythms and refining systems.</div>
        <div class="pill"><strong>Best Use:</strong> Schedule tweaks, small system upgrades, and gentle visibility.</div>
      </div>
    </header>

    <section class="days-grid">
      
      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • April 8</div>
          <div class="day-tag">Flow Check</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you notice where your days feel choppy vs. smoothly flowing.</p>
        <div class="label">Spiritual</div>
        <p>Spirit highlights that flow is often created by a few smart constraints, not by chaos.</p>
        <div class="label">Financial</div>
        <p>Good day to rearrange your schedule to better match your natural energy peaks.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Observe when you feel most clear and focused, then block those hours for your most important work.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Design your schedule around your best hours.</li><li>Move one key task into your peak-focus window.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Forcing deep work into your most distracted times.</li><li>Expecting yourself to have equal energy all day.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • April 9</div>
          <div class="day-tag">System Upgrade</div>
        </div>
        <div class="label">Emotional</div>
        <p>You may feel irritation with systems that are almost good enough but still clunky.</p>
        <div class="label">Spiritual</div>
        <p>Spirit nudges you to refine rather than rebuild; small tweaks can save hours later.</p>
        <div class="label">Financial</div>
        <p>Ideal for improving one system related to money, client work, or creative output.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Ask: “What is one friction point that, if fixed, would make everything easier?” Focus there.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Simplify a system instead of inventing a new one.</li><li>Test your improved process once today.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Redesigning everything from scratch out of frustration.</li><li>Ignoring minor annoyances because they seem small.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Fri • April 10</div>
          <div class="day-tag">Visibility Pulse</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you may feel more expressive or willing to be seen.</p>
        <div class="label">Spiritual</div>
        <p>Your higher self reminds you that people can’t engage with what they never see.</p>
        <div class="label">Financial</div>
        <p>Good for light promotion, portfolio updates, or sharing your story.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Share one concrete example of how your work helps others, even if only with a small audience.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let your genuine enthusiasm show.</li><li>Treat visibility as invitation, not demand.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Waiting until everything is perfect before you share.</li><li>Overexaggerating to impress instead of to connect.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sat • April 11</div>
          <div class="day-tag">Nervous System Reset</div>
        </div>
        <div class="label">Emotional</div>
        <p>If the week has been full, today your emotions may crave quiet and softness.</p>
        <div class="label">Spiritual</div>
        <p>Spirit encourages you to build rest into your expansion strategy, not just as a reward.</p>
        <div class="label">Financial</div>
        <p>Minimal money/work; better for restorative practices that recharge you for next week.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Schedule at least one non-negotiable restful activity and protect it like a client appointment.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Treat rest as part of the plan, not a break from it.</li><li>Notice how your mind clarifies when your body calms.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Filling every hour with tasks.</li><li>Doomscrolling or numbing out instead of true rest.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sun • April 12</div>
          <div class="day-tag">Emotional Honesty</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotional truth bubbles up—you see clearly where you’re excited and where you’re faking it.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to stop dragging along obligations that feel dead.</p>
        <div class="label">Financial</div>
        <p>Light planning day; adjust Q2 focus based on what genuinely feels alive.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write two lists: “Lit up by…” and “Drained by…” using real examples from the last two weeks.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let your feelings inform your planning.</li><li>Choose one drained-by item to sunset this month.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Gaslighting yourself about what feels heavy.</li><li>Pretending you’re fine with commitments that crush you.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • April 13</div>
          <div class="day-tag">Focused Push</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally aligned and energized, you can make a lot of progress when you choose one main target.</p>
        <div class="label">Spiritual</div>
        <p>Spirit backs deep, sustained effort today—especially on work that supports your Q2 theme.</p>
        <div class="label">Financial</div>
        <p>Excellent for moving a core project forward in a serious way.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Block 2–3 chunks of focus time and dedicate them to your most important project only.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Lean into meaningful difficulty.</li><li>Turn off non-essential notifications while working.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Splitting your best hours between low-priority tasks.</li><li>Letting interruptions dictate your day.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • April 14</div>
          <div class="day-tag">Gentle Debrief</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you’re ready to see what your recent actions are already changing.</p>
        <div class="label">Spiritual</div>
        <p>Spirit encourages micro-debriefs: quick reflections instead of long post-mortems.</p>
        <div class="label">Financial</div>
        <p>Good for reviewing metrics, responses, or internal shifts from the past two weeks.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Ask: “What three small things are already better because of what I’ve done in April?”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let early results encourage you.</li><li>Tweak your approach based on what’s clearly working.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Ignoring progress because it’s not dramatic yet.</li><li>Overreacting to one off day or one slow response.</li>
            </ul>
          </div>
        </div>
      </article>
    
    </section>
  </div>
</body>
</html>
