
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>April 1–7, 2026 • Weekly Destiny View</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #0b0d10;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1100px;
      margin: 0 auto;
      padding: 24px 16px 48px;
    }

    a {
      color: var(--accent);
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    header {
      margin-bottom: 18px;
    }

    .back-link {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      display: inline-flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 10px;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 1.7rem;
      letter-spacing: 0.06em;
      text-transform: uppercase;
    }

    .subtitle {
      font-size: 0.95rem;
      color: var(--muted);
      margin-top: 4px;
    }

    .week-meta {
      margin-top: 10px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
    }

    .pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      color: var(--muted);
      background: rgba(0, 0, 0, 0.3);
    }

    .pill strong {
      color: var(--accent);
    }

    .days-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
      margin-top: 20px;
    }

    .day-card {
      background: var(--card-bg);
      border-radius: 16px;
      padding: 10px 12px;
      border: 1px solid var(--border);
      box-shadow: 0 10px 22px rgba(0, 0, 0, 0.45);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .day-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      margin-bottom: 4px;
    }

    .day-name {
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .day-tag {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-top: 4px;
      margin-bottom: 2px;
    }

    .day-card p {
      margin: 3px 0 5px;
    }

    .bullet-list {
      padding-left: 16px;
      margin: 2px 0 4px;
    }

    .bullet-list li {
      margin-bottom: 3px;
    }

    .ritual {
      margin-top: 4px;
      padding: 5px 7px;
      border-radius: 10px;
      border: 1px dashed var(--border);
      background: rgba(0, 0, 0, 0.25);
      font-size: 0.86rem;
    }

    .ritual strong {
      color: var(--accent);
    }

    .do-avoid {
      display: flex;
      gap: 8px;
      margin-top: 4px;
      font-size: 0.8rem;
    }

    .do-avoid div {
      flex: 1;
    }

    .do-avoid b {
      display: block;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      font-size: 0.7rem;
      margin-bottom: 1px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.4rem;
      }
    }
  </style>
</head>
<body>
  <div class="page">
    <header>
      <a href="../index.php" class="back-link">← Back to Home</a>
      <h1>Week 1 • April 1–7, 2026</h1>
      <div class="subtitle">
        Grounded Expansion • Opening Q2 with rooted, realistic growth instead of frantic overreach.
      </div>
      <div class="week-meta">
        <div class="pill"><strong>Week Focus:</strong> Clarifying Q2 expansion and matching it to true capacity.</div>
        <div class="pill"><strong>Best Use:</strong> Setting quarterly themes, realistic goals and early relationship bridges.</div>
      </div>
    </header>

    <section class="days-grid">
      
      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • April 1</div>
          <div class="day-tag">Grounded Opener</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you feel the tension between wanting to accelerate and wanting to stay safe.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you into expansion that is rooted, not reckless—big moves with wise pacing.</p>
        <div class="label">Financial</div>
        <p>Good for clarifying which opportunities are truly worth your time and energy this quarter.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write a short list titled “Expansion I actually want in Q2,” focusing on how you want work and money to feel.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Name 3 areas where you’re willing to grow.</li><li>Let safety come from structure, not from staying small.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Saying yes to everything just to feel momentum.</li><li>Treating caution and fear as the same thing.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • April 2</div>
          <div class="day-tag">Capacity Check</div>
        </div>
        <div class="label">Emotional</div>
        <p>Your emotional weather tells you how much bandwidth you really have for new commitments.</p>
        <div class="label">Spiritual</div>
        <p>Spirit nudges you to adjust ambition to your nervous system, not the other way around.</p>
        <div class="label">Financial</div>
        <p>Great day for planning realistic workloads and income goals for the next 90 days.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Ask: “If I honored my true capacity, how many big projects could I hold at once?” Adjust accordingly.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Size your goals to your current capacity.</li><li>Plan in buffers instead of using every last ounce of energy.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Building a schedule that only works if you never get tired.</li><li>Equating rest with laziness.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Fri • April 3</div>
          <div class="day-tag">Connection Bridges</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally more open and social; you feel like reaching out to others on similar paths.</p>
        <div class="label">Spiritual</div>
        <p>Your soul reminds you that expansion is relational—doors often open through people.</p>
        <div class="label">Financial</div>
        <p>Good for initiating or rekindling connections that might matter later in Q2.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Send 2–3 low-pressure messages to people who feel aligned with your Q2 themes.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Follow genuine interest and respect.</li><li>Listen for where collaboration could be mutual, not one-sided.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Reaching out only when you need something.</li><li>Over-promising before you know your bandwidth.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sat • April 4</div>
          <div class="day-tag">Body-First Day</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally sensitive; your body will tell you faster than your mind when something is too much.</p>
        <div class="label">Spiritual</div>
        <p>Spirit wants you to treat your body as your primary oracle today.</p>
        <div class="label">Financial</div>
        <p>Keep finances light; better to check in with how your body responds to upcoming decisions.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Do a slow walk, stretch, or movement session and ask your body, “Where do you want less? Where do you want more?”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let your body veto at least one unnecessary obligation.</li><li>Choose comfort and support over aesthetics today.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Ignoring obvious fatigue.</li><li>Forcing yourself into density or conflict when you’re already drained.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sun • April 5</div>
          <div class="day-tag">Inner Alignment</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally reflective; you sense which parts of your life feel aligned and which feel off-key.</p>
        <div class="label">Spiritual</div>
        <p>Spirit prompts you to ask which parts of your “success picture” are still borrowed from others.</p>
        <div class="label">Financial</div>
        <p>Good for small edits: routines, expectations, or self-talk that shape your financial behavior.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Journal on: “What does success look like on my terms in Q2?” and name three non-negotiables.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Update your vision to more accurately match you.</li><li>Release one hand-me-down goal that isn’t yours.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Trying to live inside someone else’s blueprint.</li><li>Treating misalignment as a personal flaw.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • April 6</div>
          <div class="day-tag">Focused Start</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally clearer; you’re ready to turn reflection into structured action.</p>
        <div class="label">Spiritual</div>
        <p>Spirit supports you choosing one primary Q2 focus instead of scattering energy.</p>
        <div class="label">Financial</div>
        <p>Great for designating a “main project” or theme that will drive income and growth.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write at the top of today’s page: “My primary focus this quarter is…” and commit to it.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Align your tasks with that primary focus.</li><li>Say no to at least one distraction that doesn’t fit.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Trying to maintain five “primary” focuses.</li><li>Letting small urgent things erase big important ones.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • April 7</div>
          <div class="day-tag">Gentle Consolidation</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally steady; you can feel the shape of Q2 beginning to cohere.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites small consolidation moves: tidying edges, confirming decisions, organizing notes.</p>
        <div class="label">Financial</div>
        <p>Light money/work; best for admin that supports your chosen focus.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Create a single Q2 dashboard or notes page where your goals, experiments, and key dates live together.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Centralize scattered plans into one place.</li><li>Acknowledge that having a clear map calms your system.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Keeping important info across dozens of apps and notebooks.</li><li>Waiting for the “perfect tool” before organizing.</li>
            </ul>
          </div>
        </div>
      </article>
    
    </section>
  </div>
</body>
</html>
