
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>January 15–21, 2026 • Weekly Destiny View</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #0b0d10;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1100px;
      margin: 0 auto;
      padding: 24px 16px 48px;
    }

    a {
      color: var(--accent);
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    header {
      margin-bottom: 18px;
    }

    .back-link {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      display: inline-flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 10px;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 1.7rem;
      letter-spacing: 0.06em;
      text-transform: uppercase;
    }

    .subtitle {
      font-size: 0.95rem;
      color: var(--muted);
      margin-top: 4px;
    }

    .week-meta {
      margin-top: 10px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
    }

    .pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      color: var(--muted);
      background: rgba(0, 0, 0, 0.3);
    }

    .pill strong {
      color: var(--accent);
    }

    .days-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
      margin-top: 20px;
    }

    .day-card {
      background: var(--card-bg);
      border-radius: 16px;
      padding: 10px 12px;
      border: 1px solid var(--border);
      box-shadow: 0 10px 22px rgba(0, 0, 0, 0.45);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .day-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      margin-bottom: 4px;
    }

    .day-name {
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .day-tag {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-top: 4px;
      margin-bottom: 2px;
    }

    .day-card p {
      margin: 3px 0 5px;
    }

    .bullet-list {
      padding-left: 16px;
      margin: 2px 0 4px;
    }

    .bullet-list li {
      margin-bottom: 3px;
    }

    .ritual {
      margin-top: 4px;
      padding: 5px 7px;
      border-radius: 10px;
      border: 1px dashed var(--border);
      background: rgba(0, 0, 0, 0.25);
      font-size: 0.86rem;
    }

    .ritual strong {
      color: var(--accent);
    }

    .do-avoid {
      display: flex;
      gap: 8px;
      margin-top: 4px;
      font-size: 0.8rem;
    }

    .do-avoid div {
      flex: 1;
    }

    .do-avoid b {
      display: block;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      font-size: 0.7rem;
      margin-bottom: 1px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.4rem;
      }
    }
  </style>
</head>
<body>
  <div class="page">
    <header>
      <a href="../index.php" class="back-link">← Back to Home</a>
      <h1>Week 3 • January 15–21, 2026</h1>
      <div class="subtitle">
        Clearing and Choosing • Making space and committing to more aligned paths.
      </div>
      <div class="week-meta">
        <div class="pill"><strong>Week Focus:</strong> Decluttering, emotional release, and key choices.</div>
        <div class="pill"><strong>Best Use:</strong> Clearing clutter, refining trajectories, and anchoring at least one core shift.</div>
      </div>
    </header>

    <section class="days-grid">
      
      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • January 15</div>
          <div class="day-tag">Clutter Clearing</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotions may feel slightly bogged down; clutter in your environment mirrors mental static.</p>
        <div class="label">Spiritual</div>
        <p>Spirit nudges you to clear physical and digital spaces so Year 5 opportunities can find you.</p>
        <div class="label">Financial</div>
        <p>Great day for clearing old files, emails, unused tools, or leftover invoices.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Choose one space (desk, folder, inbox) and commit to clearing it for 20–30 minutes.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Release items that remind you of outdated versions of yourself.</li><li>Keep only tools and objects you truly use.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Hanging onto things “just in case.”</li><li>Trying to declutter your entire life in one evening.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Fri • January 16</div>
          <div class="day-tag">Choice Point</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you become aware of a fork in the road—continue as usual, or commit to a new approach.</p>
        <div class="label">Spiritual</div>
        <p>Your higher self asks: “What would it look like to fully back myself here?”</p>
        <div class="label">Financial</div>
        <p>Useful for making one moderate decision that brings you closer to a freer, more authentic life.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write down two paths you see: staying the same vs. choosing aligned change. Note how each feels in your body.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Make one clear choice that favors your future self.</li><li>Tell at least one trusted person what you’re choosing.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Staying in limbo out of fear.</li><li>Letting others’ expectations override your own knowing.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sat • January 17</div>
          <div class="day-tag">Emotional Detox</div>
        </div>
        <div class="label">Emotional</div>
        <p>Old emotions may surface—anger, sadness, or regret. They’re surfacing to be moved, not re-lived.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to feel feelings without attaching new stories to them.</p>
        <div class="label">Financial</div>
        <p>Keep finances simple; avoid big decisions while in the thick of strong emotion.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Let yourself cry, journal, move, or create art with what you feel. Say: “I allow this to move through me.”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Give yourself permission to feel without fixing.</li><li>Reach out for support if emotions feel overwhelming.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Judging yourself for your emotional waves.</li><li>Making permanent choices from temporary feelings.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sun • January 18</div>
          <div class="day-tag">Heart Check-In</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally softer today; you can see which choices are rooted in love vs. fear.</p>
        <div class="label">Spiritual</div>
        <p>Your soul wants your 2026 path to be heart-led, not just mind- or money-led.</p>
        <div class="label">Financial</div>
        <p>Light planning: align upcoming choices with what genuinely matters to you.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Ask in your journal: “What would I do this year if I trusted that my heart-led path could also be materially supported?”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let your values guide your calendar and commitments.</li><li>Say yes to what feels alive, not just logical.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Ignoring desires because they seem impractical.</li><li>Overriding your heart with pure rationalization.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • January 19</div>
          <div class="day-tag">Focused Initiative</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally energized, you’re ready to push one project or idea further than usual.</p>
        <div class="label">Spiritual</div>
        <p>Spirit amplifies motion—once you start, momentum builds faster than expected.</p>
        <div class="label">Financial</div>
        <p>Ideal day for initiating a new habit, project phase, or collaboration that supports your expansion arc.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Choose one project that matters and work on it in two or three focused blocks today.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Ride your energy wave toward meaningful work.</li><li>Protect focused pockets of time from interruptions.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Scattering your energy across too many new things.</li><li>Letting minor tasks eat your prime hours.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • January 20</div>
          <div class="day-tag">Reality & Refinement</div>
        </div>
        <div class="label">Emotional</div>
        <p>You may feel a bit more grounded or sober; enthusiasm meets logistics.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to refine plans, not abandon them, in response to real-world constraints.</p>
        <div class="label">Financial</div>
        <p>Good for adjusting timelines, scope, or expectations around money and work.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Ask: “What adjustments would make this plan 30% more realistic while still exciting?”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Refine your projects to fit your true capacity.</li><li>Communicate clearly with collaborators about any changes.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Pretending you can do everything at once.</li><li>Swinging from over-optimism to total defeat.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • January 21</div>
          <div class="day-tag">Anchor the Shift</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you sense the first real anchor points of the year taking shape.</p>
        <div class="label">Spiritual</div>
        <p>Your deeper self is saying: “These are the changes we’re actually keeping.”</p>
        <div class="label">Financial</div>
        <p>Suitable for solidifying one new habit, boundary, or system you’ve been testing.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Choose one change from this month and formally commit to it for the next 30 days.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Mark your commitment visibly (calendar, note, altar).</li><li>Tell your future self: “We’re really doing this now.”</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Keeping everything vague and negotiable.</li><li>Treating every change as temporary and optional.</li>
            </ul>
          </div>
        </div>
      </article>
    
    </section>
  </div>
</body>
</html>
