
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>January 8–14, 2026 • Weekly Destiny View</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #0b0d10;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1100px;
      margin: 0 auto;
      padding: 24px 16px 48px;
    }

    a {
      color: var(--accent);
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    header {
      margin-bottom: 18px;
    }

    .back-link {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      display: inline-flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 10px;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 1.7rem;
      letter-spacing: 0.06em;
      text-transform: uppercase;
    }

    .subtitle {
      font-size: 0.95rem;
      color: var(--muted);
      margin-top: 4px;
    }

    .week-meta {
      margin-top: 10px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
    }

    .pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      color: var(--muted);
      background: rgba(0, 0, 0, 0.3);
    }

    .pill strong {
      color: var(--accent);
    }

    .days-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
      margin-top: 20px;
    }

    .day-card {
      background: var(--card-bg);
      border-radius: 16px;
      padding: 10px 12px;
      border: 1px solid var(--border);
      box-shadow: 0 10px 22px rgba(0, 0, 0, 0.45);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .day-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      margin-bottom: 4px;
    }

    .day-name {
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .day-tag {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-top: 4px;
      margin-bottom: 2px;
    }

    .day-card p {
      margin: 3px 0 5px;
    }

    .bullet-list {
      padding-left: 16px;
      margin: 2px 0 4px;
    }

    .bullet-list li {
      margin-bottom: 3px;
    }

    .ritual {
      margin-top: 4px;
      padding: 5px 7px;
      border-radius: 10px;
      border: 1px dashed var(--border);
      background: rgba(0, 0, 0, 0.25);
      font-size: 0.86rem;
    }

    .ritual strong {
      color: var(--accent);
    }

    .do-avoid {
      display: flex;
      gap: 8px;
      margin-top: 4px;
      font-size: 0.8rem;
    }

    .do-avoid div {
      flex: 1;
    }

    .do-avoid b {
      display: block;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      font-size: 0.7rem;
      margin-bottom: 1px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.4rem;
      }
    }
  </style>
</head>
<body>
  <div class="page">
    <header>
      <a href="../index.php" class="back-link">← Back to Home</a>
      <h1>Week 2 • January 8–14, 2026</h1>
      <div class="subtitle">
        Establishing Rhythm • Building sustainable routines that can support real expansion.
      </div>
      <div class="week-meta">
        <div class="pill"><strong>Week Focus:</strong> Daily rhythm and realistic routines.</div>
        <div class="pill"><strong>Best Use:</strong> Experimenting with schedules, early networking, and refining goals.</div>
      </div>
    </header>

    <section class="days-grid">
      
      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • January 8</div>
          <div class="day-tag">Rhythm Finder</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you feel the desire for a real rhythm instead of random bursts of effort.</p>
        <div class="label">Spiritual</div>
        <p>Spirit encourages you to design days that your future self can actually maintain.</p>
        <div class="label">Financial</div>
        <p>Good day to experiment with a daily schedule that balances focus, outreach, and rest.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Sketch an ideal weekday schedule that includes focus blocks, movement, and downtime.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Test one new time block (e.g., 90 minutes of deep work).</li><li>Protect at least one pocket of quiet time.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Letting notifications carve up your day.</li><li>Over-promising time to others without checking your capacity.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Fri • January 9</div>
          <div class="day-tag">Connection Warm-Up</div>
        </div>
        <div class="label">Emotional</div>
        <p>You may feel drawn to reconnect with people you lost touch with last year.</p>
        <div class="label">Spiritual</div>
        <p>Your soul reminds you that expansion doesn’t happen alone; allies and community matter.</p>
        <div class="label">Financial</div>
        <p>Light networking day—ideal for low-pressure check-ins, not hard sells.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Send one genuine “how are you?” message to someone who feels aligned with your next chapter.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Follow curiosity when it comes to people.</li><li>Be honest and simple in your outreach.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Forcing big asks on a first reconnection.</li><li>Interacting only from a place of need.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sat • January 10</div>
          <div class="day-tag">Nervous System Reset</div>
        </div>
        <div class="label">Emotional</div>
        <p>If you’ve pushed this week, your emotions may feel tender; irritability may flag the need for rest.</p>
        <div class="label">Spiritual</div>
        <p>Spirit prioritizes capacity-building; today is about caring for the system that will carry you through expansion.</p>
        <div class="label">Financial</div>
        <p>No heavy money moves—best for grounding practices and clearing stress before the next week.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Do something simple that your body loves: stretching, a slow walk, a bath, time in nature.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Notice how rest actually improves your clarity.</li><li>Give yourself permission to “waste time” on genuine restoration.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Forcing productivity to “earn” rest.</li><li>Self-criticism for needing more downtime than expected.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sun • January 11</div>
          <div class="day-tag">Inner Compass Check</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you may feel a quiet sense of “is this path still right?” around one area of life.</p>
        <div class="label">Spiritual</div>
        <p>Your inner compass is recalibrating; stay curious rather than panicked about doubts.</p>
        <div class="label">Financial</div>
        <p>Light review of goals and intentions—adjust them to feel more humane and true.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Ask in your journal: “If I trusted my inner compass completely, what small change would I make this week?”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let yourself update goals that no longer feel right.</li><li>Lean into honesty instead of obligation.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Doubling down on goals just because you declared them.</li><li>Ignoring your body’s “no” signals.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • January 12</div>
          <div class="day-tag">Focused Start</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally steady, you’re well-positioned to get traction on one important project.</p>
        <div class="label">Spiritual</div>
        <p>Spirit supports unglamorous consistency today; you may feel less dramatic but more effective.</p>
        <div class="label">Financial</div>
        <p>Great day for progress on a money- or work-related task that benefits from sustained focus.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Pick one key task and commit to finishing at least a meaningful chunk before checking messages.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Tackle your most important work early.</li><li>Minimize distractions during your first deep-work block.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Starting your day in your inbox.</li><li>Splitting your attention across too many priorities.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • January 13</div>
          <div class="day-tag">Feedback & Fine-Tuning</div>
        </div>
        <div class="label">Emotional</div>
        <p>You may feel slightly sensitive to feedback, but there’s gold in what you hear today.</p>
        <div class="label">Spiritual</div>
        <p>Spirit invites you to treat feedback as information, not proof of your worth.</p>
        <div class="label">Financial</div>
        <p>Ideal for reviewing responses to any early-year outreach, offers, or experiments.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Note patterns in feedback—what do people consistently appreciate about your work? What confuses them?
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Use feedback to clarify your messaging.</li><li>Ask one clarifying question instead of making assumptions.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Taking every comment personally.</li><li>Throwing out a good idea just because it needs tweaks.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • January 14</div>
          <div class="day-tag">Mini-Milestone</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you feel ready to acknowledge the first small wave of progress this year.</p>
        <div class="label">Spiritual</div>
        <p>Spirit wants you to recognize the power of tiny milestones—they build momentum.</p>
        <div class="label">Financial</div>
        <p>Good day to mark where your finances or workflows are already slightly better than last month.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write a short list: “Wins of the first two weeks of 2026”—include emotional and spiritual wins too.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Celebrate your early follow-through.</li><li>Let yourself feel proud of consistency, not just outcomes.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Dismissing small wins as meaningless.</li><li>Moving the goalpost so you never feel satisfied.</li>
            </ul>
          </div>
        </div>
      </article>
    
    </section>
  </div>
</body>
</html>
