
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>January 1–7, 2026 • Weekly Destiny View</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #0b0d10;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1100px;
      margin: 0 auto;
      padding: 24px 16px 48px;
    }

    a {
      color: var(--accent);
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    header {
      margin-bottom: 18px;
    }

    .back-link {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      display: inline-flex;
      align-items: center;
      gap: 6px;
      margin-bottom: 10px;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 1.7rem;
      letter-spacing: 0.06em;
      text-transform: uppercase;
    }

    .subtitle {
      font-size: 0.95rem;
      color: var(--muted);
      margin-top: 4px;
    }

    .week-meta {
      margin-top: 10px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
    }

    .pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      color: var(--muted);
      background: rgba(0, 0, 0, 0.3);
    }

    .pill strong {
      color: var(--accent);
    }

    .days-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 14px;
      margin-top: 20px;
    }

    .day-card {
      background: var(--card-bg);
      border-radius: 16px;
      padding: 10px 12px;
      border: 1px solid var(--border);
      box-shadow: 0 10px 22px rgba(0, 0, 0, 0.45);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .day-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      margin-bottom: 4px;
    }

    .day-name {
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .day-tag {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-top: 4px;
      margin-bottom: 2px;
    }

    .day-card p {
      margin: 3px 0 5px;
    }

    .bullet-list {
      padding-left: 16px;
      margin: 2px 0 4px;
    }

    .bullet-list li {
      margin-bottom: 3px;
    }

    .ritual {
      margin-top: 4px;
      padding: 5px 7px;
      border-radius: 10px;
      border: 1px dashed var(--border);
      background: rgba(0, 0, 0, 0.25);
      font-size: 0.86rem;
    }

    .ritual strong {
      color: var(--accent);
    }

    .do-avoid {
      display: flex;
      gap: 8px;
      margin-top: 4px;
      font-size: 0.8rem;
    }

    .do-avoid div {
      flex: 1;
    }

    .do-avoid b {
      display: block;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      font-size: 0.7rem;
      margin-bottom: 1px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.4rem;
      }
    }
  </style>
</head>
<body>
  <div class="page">
    <header>
      <a href="../index.php" class="back-link">← Back to Home</a>
      <h1>Week 1 • January 1–7, 2026</h1>
      <div class="subtitle">
        Opening the Door • Soft launch into your Personal Year 5 expansion arc.
      </div>
      <div class="week-meta">
        <div class="pill"><strong>Week Focus:</strong> Gentle reset and emotional/financial baselining.</div>
        <div class="pill"><strong>Best Use:</strong> Reflection, light simplification, and choosing sustainable micro-commitments.</div>
      </div>
    </header>

    <section class="days-grid">
      
      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Thu • January 1</div>
          <div class="day-tag">Threshold Day</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally heightened; you feel both possibility and pressure. Old habits may tug while new desires call louder.</p>
        <div class="label">Spiritual</div>
        <p>Spirit opens a fresh door: this is less about resolutions and more about quietly choosing who you will be this year.</p>
        <div class="label">Financial</div>
        <p>Gentle review day. Not for drastic money moves—just noticing where you stand and what you want to change.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Write a short letter to your future self at the end of 2026, describing how you hope to feel about your life and work.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Name one feeling you want as a baseline this year.</li><li>Decide what “enough” looks like in terms of pace and effort.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Making rigid resolutions from guilt.</li><li>Judging yourself for where you are starting.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Fri • January 2</div>
          <div class="day-tag">Soft Reset</div>
        </div>
        <div class="label">Emotional</div>
        <p>You may feel a subtle emotional hangover from expectations around the new year. Gentleness works better than discipline today.</p>
        <div class="label">Spiritual</div>
        <p>Your soul wants you to approach this year like a long journey, not a sprint. Small beginnings are holy.</p>
        <div class="label">Financial</div>
        <p>Look at recurring expenses and subscriptions; identify one thing you can simplify or cancel.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Light a candle and say: “I allow this year to unfold at a pace that honors my body and nervous system.”
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Clear one small recurring cost or clutter point.</li><li>Ease into routines instead of forcing them.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Comparing your start to others’ mid-story.</li><li>Over-scheduling the first week of the year.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sat • January 3</div>
          <div class="day-tag">Body Check-In</div>
        </div>
        <div class="label">Emotional</div>
        <p>Your emotions are closely tied to your physical state today; tiredness or tension may color your mood.</p>
        <div class="label">Spiritual</div>
        <p>Spirit uses your body as an honest barometer—notice where you feel open vs. compressed.</p>
        <div class="label">Financial</div>
        <p>Focus on restoring energy rather than pushing productivity; future financial choices will be clearer when you’re rested.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Do a 10-minute scan from head to toe, noting where you feel contracted. Breathe into those spots and stretch if you can.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Choose foods, movement, and rest that feel replenishing.</li><li>Adjust plans if your body clearly says “not today.”</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Judging yourself for needing rest.</li><li>Making big money decisions when exhausted.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Sun • January 4</div>
          <div class="day-tag">Emotional Sorting</div>
        </div>
        <div class="label">Emotional</div>
        <p>You may feel waves of nostalgia or reflection about previous years and how far you’ve come.</p>
        <div class="label">Spiritual</div>
        <p>Your inner guidance invites you to release old emotional stories that no longer match who you’re becoming.</p>
        <div class="label">Financial</div>
        <p>Not a high-stakes money day—better for sorting paperwork, files, or budgets quietly.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Journal on: “What story about myself am I ready to retire this year?” and then write a new story that feels more true.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Let old guilt or shame move through you without clinging.</li><li>Keep the day gentle and introspective.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Reopening old emotional wounds just to relive them.</li><li>Forcing social plans if you crave solitude.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Mon • January 5</div>
          <div class="day-tag">Baseline Clarity</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you may feel ready for practical clarity: what’s on your plate, what isn’t, and what needs to go.</p>
        <div class="label">Spiritual</div>
        <p>Spirit supports realistic self-assessment today—no drama, just data.</p>
        <div class="label">Financial</div>
        <p>Good for simple financial baselining: current income sources, debts, and recurring costs.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Make a one-page “Current Reality” snapshot: income, expenses, responsibilities, and energy drains.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Be honest about your numbers and time.</li><li>Treat clarity as power, not a verdict.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Avoiding looking at your accounts.</li><li>Spinning in vague anxiety instead of getting specific.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Tue • January 6</div>
          <div class="day-tag">Micro-Commitments</div>
        </div>
        <div class="label">Emotional</div>
        <p>You might feel pulled to do something tangible but still small; micro-commitments ease you into motion.</p>
        <div class="label">Spiritual</div>
        <p>Your higher self whispers: “Consistency is more powerful than intensity this year.”</p>
        <div class="label">Financial</div>
        <p>Choose one financial or work habit you can commit to most days (tracking, outreach, review).</p>
        <div class="ritual">
          <strong>Ritual:</strong> Set a 5-minute daily commitment that’s almost too easy, like one line of tracking or one small reach-out.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Anchor one mini-habit that supports expansion.</li><li>Keep promises to yourself, even in tiny form.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Trying to overhaul everything in one day.</li><li>Treating small steps as unimportant.</li>
            </ul>
          </div>
        </div>
      </article>
    

      <article class="day-card">
        <div class="day-header">
          <div class="day-name">Wed • January 7</div>
          <div class="day-tag">Gentle Integration</div>
        </div>
        <div class="label">Emotional</div>
        <p>Emotionally, you begin to sense how this year might feel if you let it—lighter, freer, more honest.</p>
        <div class="label">Spiritual</div>
        <p>Spirit integrates the first week’s intentions; your job is simply not to rush the process.</p>
        <div class="label">Financial</div>
        <p>Light money planning only: lay out the next week’s priorities and a simple structure.</p>
        <div class="ritual">
          <strong>Ritual:</strong> Before bed, list three things that already feel different (even slightly) from last year’s energy.
        </div>
        <div class="do-avoid">
          <div>
            <b>DO</b>
            <ul class="bullet-list">
              <li>Notice and name early signs of change.</li><li>Honor yourself for starting slowly and consciously.</li>
            </ul>
          </div>
          <div>
            <b>AVOID</b>
            <ul class="bullet-list">
              <li>Criticizing yourself for not doing more.</li><li>Comparing your first week to anyone else’s whole year.</li>
            </ul>
          </div>
        </div>
      </article>
    
    </section>
  </div>
</body>
</html>
