<?php
// Destiny Almanac • 2026 Full Year Index (Q1–Q4 ready)
// Q1 & Q2 weeks are currently populated; Q3 & Q4 links are pre-wired
// so future quarter drops just require adding matching week files.
?><!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Destiny Almanac • 2026 Master Timeline</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    :root {
      --bg: #05060a;
      --bg-alt: #151821;
      --text: #f5f7fb;
      --muted: #a3a8c3;
      --accent: #e2b857;
      --accent-soft: rgba(226, 184, 87, 0.12);
      --border: #292d3b;
      --card-bg: #151821;
      --shadow: 0 18px 35px rgba(0, 0, 0, 0.5);
      --font-main: system-ui, -apple-system, BlinkMacSystemFont, "SF Pro Text",
        "Segoe UI", sans-serif;
      --font-display: "Georgia", "Times New Roman", serif;
    }

    * {
      box-sizing: border-box;
    }

    body {
      margin: 0;
      font-family: var(--font-main);
      background: radial-gradient(circle at top, #2a213b 0, #050308 60%);
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    .page {
      max-width: 1220px;
      margin: 0 auto;
      padding: 24px 16px 56px;
    }

    header {
      margin-bottom: 22px;
      text-align: left;
    }

    h1 {
      margin: 0;
      font-family: var(--font-display);
      font-size: 2.1rem;
      letter-spacing: 0.1em;
      text-transform: uppercase;
    }

    .subtitle {
      margin-top: 8px;
      color: var(--muted);
      font-size: 0.95rem;
    }

    .years-row {
      margin-top: 12px;
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
    }

    .year-pill {
      padding: 4px 10px;
      border-radius: 999px;
      border: 1px solid var(--border);
    }

    .hint {
      margin-top: 8px;
      font-size: 0.78rem;
      color: var(--muted);
    }

    .quarter-label {
      margin-top: 20px;
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.12em;
      color: var(--accent);
    }

    .months-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 16px;
      margin-top: 10px;
    }

    .month-card {
      background: var(--card-bg);
      border-radius: 18px;
      padding: 14px 16px 16px;
      border: 1px solid var(--border);
      box-shadow: var(--shadow);
      font-size: 0.9rem;
      color: var(--muted);
    }

    .month-header {
      display: flex;
      justify-content: space-between;
      align-items: baseline;
      gap: 8px;
      margin-bottom: 4px;
    }

    .month-name {
      font-family: var(--font-display);
      font-size: 1.1rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .month-year {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--accent);
    }

    .month-theme {
      font-size: 0.86rem;
      margin-bottom: 6px;
    }

    .tag-row {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      margin-bottom: 8px;
    }

    .tag {
      font-size: 0.7rem;
      text-transform: uppercase;
      letter-spacing: 0.07em;
      border-radius: 999px;
      padding: 2px 8px;
      border: 1px solid var(--border);
      color: var(--muted);
    }

    .week-select-label {
      font-size: 0.75rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: var(--muted);
      margin-bottom: 3px;
    }

    select {
      width: 100%;
      padding: 6px 8px;
      border-radius: 999px;
      border: 1px solid var(--border);
      background: #05060a;
      color: var(--text);
      font-size: 0.82rem;
      font-family: var(--font-main);
    }

    option {
      color: #000;
    }

    .note-small {
      font-size: 0.75rem;
      color: var(--muted);
      margin-top: 6px;
    }

    @media (max-width: 720px) {
      h1 {
        font-size: 1.6rem;
      }
    }
  </style>
  <script>
    function goToWeek(sel) {
      if (sel && sel.value) {
        window.location.href = sel.value;
      }
    }
  </script>
</head>
<body>
  <div class="page">
    <header>
      <h1>Destiny Almanac</h1>
      <div class="subtitle">
        2026 Multi-Year Destiny Forecast • Weekly & Daily Guidance<br />
        Numerology-based arc: <strong>Personal Year 5 — Expansion & Power</strong>.
      </div>
      <div class="years-row">
        <div class="year-pill"><strong>2026</strong> • All 4 Quarters • Weeks Pre-Wired</div>
      </div>
      <div class="hint">
        Each month below has a dropdown. Choose a week to open its detailed
        emotional, spiritual, financial and ritual guidance. Q1 & Q2 content is live;
        Q3 & Q4 links are already wired and will activate as their week files are added.
      </div>
    </header>

    <!-- Q1: JAN–MAR -->
    <div class="quarter-label">Q1 • January – March 2026</div>
    <section class="months-grid">
      <!-- January 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">January</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> Opening the Door — gentle acceleration, clearing leftovers from 2025, setting new baselines.
        </p>
        <div class="tag-row">
          <span class="tag">Reset</span>
          <span class="tag">Foundations</span>
          <span class="tag">Energy Calibration</span>
        </div>
        <div class="week-select-label">Open a January week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-01-week1.php">Week 1 • Jan 1–7 — Opening the Door</option>
          <option value="weeks/2026-01-week2.php">Week 2 • Jan 8–14 — Establishing Rhythm</option>
          <option value="weeks/2026-01-week3.php">Week 3 • Jan 15–21 — Clearing & Choosing</option>
          <option value="weeks/2026-01-week4.php">Week 4 • Jan 22–31 — Laying Foundations</option>
        </select>
        <div class="note-small">Baseline reset month for your entire Year 5 journey.</div>
      </article>

      <!-- February 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">February</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> Testing New Momentum — trial runs, experiments, and small risks previewing March’s surge.
        </p>
        <div class="tag-row">
          <span class="tag">Experiment</span>
          <span class="tag">Signals</span>
          <span class="tag">Preparation</span>
        </div>
        <div class="week-select-label">Open a February week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-02-week1.php">Week 1 • Feb 1–7 — Experiments & Signals</option>
          <option value="weeks/2026-02-week2.php">Week 2 • Feb 8–14 — Refining Experiments</option>
          <option value="weeks/2026-02-week3.php">Week 3 • Feb 15–21 — Choosing What Stays</option>
          <option value="weeks/2026-02-week4.php">Week 4 • Feb 22–28 — Preparing for March’s Surge</option>
        </select>
      </article>

      <!-- March 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">March</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> Power Surge — decisions, bold moves, and visible shifts in money, work and identity.
        </p>
        <div class="tag-row">
          <span class="tag">Power</span>
          <span class="tag">Courage</span>
          <span class="tag">Launch Energy</span>
        </div>
        <div class="week-select-label">Open a March week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-03-week1.php">Week 1 • Mar 1–7 — Warming Up the Engine</option>
          <option value="weeks/2026-03-week2.php">Week 2 • Mar 8–14 — Crossing the Threshold</option>
          <option value="weeks/2026-03-week3.php">Week 3 • Mar 15–21 — Owning Your Power</option>
          <option value="weeks/2026-03-week4.php">Week 4 • Mar 22–31 — Consolidate & Aim Forward</option>
        </select>
        <div class="note-small">
          March is your high-voltage month; Q2 builds on what you decide here.
        </div>
      </article>
    </section>

    <!-- Q2: APR–JUN -->
    <div class="quarter-label">Q2 • April – June 2026</div>
    <section class="months-grid">
      <!-- April 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">April</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> Stabilizing Expansion — grounding your growth so it’s sustainable, not chaotic.
        </p>
        <div class="tag-row">
          <span class="tag">Grounding</span>
          <span class="tag">Stability</span>
          <span class="tag">Capacity</span>
        </div>
        <div class="week-select-label">Open an April week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-04-week1.php">Week 1 • Apr 1–7 — Grounded Expansion</option>
          <option value="weeks/2026-04-week2.php">Week 2 • Apr 8–14 — Flow & Structure</option>
          <option value="weeks/2026-04-week3.php">Week 3 • Apr 15–21 — Deepening Commitment</option>
          <option value="weeks/2026-04-week4.php">Week 4 • Apr 22–30 — Stabilizing Changes</option>
        </select>
        <div class="note-small">Use April to right-size your ambitions to your true capacity.</div>
      </article>

      <!-- May 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">May</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> Visibility & Flow — opening channels so your signal and work can reach further.
        </p>
        <div class="tag-row">
          <span class="tag">Visibility</span>
          <span class="tag">Outreach</span>
          <span class="tag">Flow</span>
        </div>
        <div class="week-select-label">Open a May week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-05-week1.php">Week 1 • May 1–7 — Opening Channels</option>
          <option value="weeks/2026-05-week2.php">Week 2 • May 8–14 — Rhythms of Outreach</option>
          <option value="weeks/2026-05-week3.php">Week 3 • May 15–21 — Flow & Adjustment</option>
          <option value="weeks/2026-05-week4.php">Week 4 • May 22–31 — Consolidation & Gratitude</option>
        </select>
      </article>

      <!-- June 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">June</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> Mid-Year Integration — reviewing H1, tuning systems, and aiming the second half of the year.
        </p>
        <div class="tag-row">
          <span class="tag">Integration</span>
          <span class="tag">Systems</span>
          <span class="tag">Mid-Year</span>
        </div>
        <div class="week-select-label">Open a June week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-06-week1.php">Week 1 • Jun 1–7 — Mid-Year Mirror</option>
          <option value="weeks/2026-06-week2.php">Week 2 • Jun 8–14 — Re-Tuning Systems</option>
          <option value="weeks/2026-06-week3.php">Week 3 • Jun 15–21 — Emotional Integration</option>
          <option value="weeks/2026-06-week4.php">Week 4 • Jun 22–30 — Aiming H2</option>
        </select>
        <div class="note-small">
          June acts as a hinge: everything after this is shaped by what you integrate here.
        </div>
      </article>
    </section>

    <!-- Q3: JUL–SEP (links pre-wired, content to come) -->
    <div class="quarter-label">Q3 • July – September 2026 (pre-wired)</div>
    <section class="months-grid">
      <!-- July 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">July</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> To be detailed in Q3 package — links below already point to the July week files.
        </p>
        <div class="tag-row">
          <span class="tag">Q3</span>
          <span class="tag">Future Content</span>
        </div>
        <div class="week-select-label">Open a July week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-07-week1.php">Week 1 • Jul 1–7</option>
          <option value="weeks/2026-07-week2.php">Week 2 • Jul 8–14</option>
          <option value="weeks/2026-07-week3.php">Week 3 • Jul 15–21</option>
          <option value="weeks/2026-07-week4.php">Week 4 • Jul 22–31</option>
        </select>
        <div class="note-small">Once the Q3 files are added, these links will light up without changing this index.</div>
      </article>

      <!-- August 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">August</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> To be detailed in Q3 package — structure is ready, content forthcoming.
        </p>
        <div class="tag-row">
          <span class="tag">Q3</span>
          <span class="tag">Future Content</span>
        </div>
        <div class="week-select-label">Open an August week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-08-week1.php">Week 1 • Aug 1–7</option>
          <option value="weeks/2026-08-week2.php">Week 2 • Aug 8–14</option>
          <option value="weeks/2026-08-week3.php">Week 3 • Aug 15–21</option>
          <option value="weeks/2026-08-week4.php">Week 4 • Aug 22–31</option>
        </select>
      </article>

      <!-- September 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">September</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> To be detailed in Q3 package — integration will focus on late-year positioning.
        </p>
        <div class="tag-row">
          <span class="tag">Q3</span>
          <span class="tag">Future Content</span>
        </div>
        <div class="week-select-label">Open a September week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-09-week1.php">Week 1 • Sep 1–7</option>
          <option value="weeks/2026-09-week2.php">Week 2 • Sep 8–14</option>
          <option value="weeks/2026-09-week3.php">Week 3 • Sep 15–21</option>
          <option value="weeks/2026-09-week4.php">Week 4 • Sep 22–30</option>
        </select>
      </article>
    </section>

    <!-- Q4: OCT–DEC (links pre-wired, content to come) -->
    <div class="quarter-label">Q4 • October – December 2026 (pre-wired)</div>
    <section class="months-grid">
      <!-- October 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">October</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> To be detailed in Q4 package — depth and culmination arcs will live here.
        </p>
        <div class="tag-row">
          <span class="tag">Q4</span>
          <span class="tag">Future Content</span>
        </div>
        <div class="week-select-label">Open an October week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-10-week1.php">Week 1 • Oct 1–7</option>
          <option value="weeks/2026-10-week2.php">Week 2 • Oct 8–14</option>
          <option value="weeks/2026-10-week3.php">Week 3 • Oct 15–21</option>
          <option value="weeks/2026-10-week4.php">Week 4 • Oct 22–31</option>
        </select>
      </article>

      <!-- November 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">November</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> To be detailed in Q4 package — harvest, refinement, and consolidation.
        </p>
        <div class="tag-row">
          <span class="tag">Q4</span>
          <span class="tag">Future Content</span>
        </div>
        <div class="week-select-label">Open a November week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-11-week1.php">Week 1 • Nov 1–7</option>
          <option value="weeks/2026-11-week2.php">Week 2 • Nov 8–14</option>
          <option value="weeks/2026-11-week3.php">Week 3 • Nov 15–21</option>
          <option value="weeks/2026-11-week4.php">Week 4 • Nov 22–30</option>
        </select>
      </article>

      <!-- December 2026 -->
      <article class="month-card">
        <div class="month-header">
          <div class="month-name">December</div>
          <div class="month-year">2026 • Year 5</div>
        </div>
        <p class="month-theme">
          <strong>Theme:</strong> To be detailed in Q4 package — closure, review, and transition into the next cycle.
        </p>
        <div class="tag-row">
          <span class="tag">Q4</span>
          <span class="tag">Future Content</span>
        </div>
        <div class="week-select-label">Open a December week</div>
        <select onchange="goToWeek(this)">
          <option value="">Select week…</option>
          <option value="weeks/2026-12-week1.php">Week 1 • Dec 1–7</option>
          <option value="weeks/2026-12-week2.php">Week 2 • Dec 8–14</option>
          <option value="weeks/2026-12-week3.php">Week 3 • Dec 15–21</option>
          <option value="weeks/2026-12-week4.php">Week 4 • Dec 22–31</option>
        </select>
        <div class="note-small">
          As future quarter bundles (Q3 & Q4) are generated, just drop the matching week files into /weeks/.
          This index page never has to change.
        </div>
      </article>
    </section>
  </div>
</body>
</html>
